<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once(ENGINE_DIR . '/data/dbconfig.php');
/*
	// Удаление таблиц перед повторным созданием
	if ($db_connect->query("SHOW TABLES LIKE 'lots'")->num_rows) {
		$db_connect->query('TRUNCATE TABLE `lots`');
	}
	if ($db_connect->query("SHOW TABLES LIKE 'lots_categories'")->num_rows) {
		$db_connect->query('TRUNCATE TABLE `lots_categories`');
	}*/

	// Флаг для отслеживания успешности выполнения запросов
$successFlag = true;
$enabledDatabase = $config["database_settings"]["enabled_database"];
$currentDatabaseSettings = $config["database_settings"][$enabledDatabase];
// Массив с запросами на создание таблиц
$createTablesPG = [
    'CREATE TABLE IF NOT EXISTS "lots" (
			"id" SERIAL PRIMARY KEY, -- Уникальный идентификатор аукциона
			"author" VARCHAR(40), -- Автор, создавший аукцион
			"created_at" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания записи аукциона
			"language" VARCHAR(190), -- Язык мероприятия
			"title" VARCHAR(255) NOT NULL, -- Название аукциона
			"alt_name" VARCHAR(190), -- Альтернативное имя (URL)
			"image" VARCHAR(255), -- Ссылка на изображение товара
			"short_desc" TEXT, -- Краткое описание мероприятия
			"full_desc" TEXT, -- Полное описание мероприятия
			"start_price" DECIMAL(10, 2) NOT NULL, -- Начальная цена
			"current_price" DECIMAL(10, 2), -- Текущая цена
			"buy_now_price" DECIMAL(10, 2), -- Цена "Купить сейчас"
			"start_date" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время начала аукциона
			"end_date" TIMESTAMP, -- Дата и время окончания аукциона
			"participants" INT, -- Количество подписанных участников
			"capacity" INT, -- Максимальное количество участников
			"status" VARCHAR(50), -- Статус аукциона (active, completed, canceled)
			"winner" VARCHAR(40), -- Победитель аукциона
			"bids_count" INT DEFAULT 0, -- Количество ставок
			"views" INT DEFAULT 0, -- Количество просмотров
			"tags" VARCHAR(255), -- Теги (разделенные запятыми)
			"meta_desc" VARCHAR(300), -- Мета-описание для SEO
			"meta_keys" TEXT -- Мета-ключевые слова для SEO
		)',

    'CREATE TABLE IF NOT EXISTS "lots_fields" (
			"id" SERIAL PRIMARY KEY, -- Уникальный идентификатор
			"x_name" VARCHAR(255) NOT NULL, -- Заголовок столбца в таблице
			"column_type" VARCHAR(255) NOT NULL, -- Тип столбца в таблице
			"column_length" INT DEFAULT 0 -- Длина
		)',

    'CREATE TABLE IF NOT EXISTS "lots_field_values" (
			"id" SERIAL PRIMARY KEY, -- Уникальный идентификатор
			"lots_id" INT NOT NULL, -- ID новости
			"field_id" INT NOT NULL, -- ID поля из lots_fields
			"x_value" TEXT NOT NULL, -- Значение поля (универсальное хранилище)
			FOREIGN KEY ("lots_id") REFERENCES "lots"("id") ON DELETE CASCADE,
			FOREIGN KEY ("field_id") REFERENCES "lots_fields"("id") ON DELETE CASCADE
		)',

    'CREATE TABLE IF NOT EXISTS "lots_categories" (
			"id" SERIAL PRIMARY KEY,
			"parentid" INT, -- Родительская категория
			"position" INT, -- Позиция
			"language" VARCHAR(190), -- Язык
			"name" VARCHAR(50), -- Название категории
			"alt_name" VARCHAR(50), -- Альтернативное имя (URL)
			"meta_desc" VARCHAR(300), -- Мета-описание для SEO
			"meta_keys" TEXT, -- Мета-ключевые слова для SEO
			"short_tpl" VARCHAR(40), -- Шаблон для краткого описания
			"full_tpl" VARCHAR(40), -- Шаблон для полного описания
			"comments" BOOLEAN, -- Наличие комментариев
			"views" INT DEFAULT 0 -- Количество просмотров
		)',

    'CREATE TABLE IF NOT EXISTS "lots_participants" (
			"id" SERIAL PRIMARY KEY, -- Уникальный идентификатор записи
			"lots_title" VARCHAR(255), -- Название лота
			"user_id" INT NOT NULL, -- ID пользователя
			"username" VARCHAR(255), -- Имя пользователя
			"phone" VARCHAR(20), -- Телефон пользователя
			"social_url" VARCHAR(255), -- Сссылка на страницу в соц. сети
			"registration_date" TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата подписки
			"status" VARCHAR(50), -- Статус подписки
			"ip" VARCHAR(45), -- IP-адрес пользователя
			"city" VARCHAR(255), -- Город пользователя
			"notes" TEXT -- Дополнительные заметки
		)',

    'CREATE TABLE IF NOT EXISTS lots_cat_relations (
        lots_id INT NOT NULL,
        category_id INT NOT NULL,
        PRIMARY KEY (lots_id, category_id),
        CONSTRAINT fk_lots
            FOREIGN KEY (lots_id) REFERENCES lots(id)
            ON DELETE CASCADE
            ON UPDATE CASCADE,
        CONSTRAINT fkl_category
            FOREIGN KEY (category_id) REFERENCES lots_categories(id)
            ON DELETE CASCADE
            ON UPDATE CASCADE
    );'
];

$createTablesMySQL = [
    'CREATE TABLE IF NOT EXISTS `lots` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор аукциона
			`author` VARCHAR(40) DEFAULT NULL, -- Автор, создавший аукцион
			`created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата создания записи аукциона
			`language` VARCHAR(190) DEFAULT NULL, -- Язык мероприятия
			`title` VARCHAR(255) NOT NULL, -- Название аукциона
			`alt_name` VARCHAR(190) DEFAULT NULL, -- Альтернативное имя (URL)
			`image` VARCHAR(255) DEFAULT NULL, -- Ссылка на изображение товара
			`short_desc` MEDIUMTEXT DEFAULT NULL, -- Краткое описание мероприятия
			`full_desc` MEDIUMTEXT DEFAULT NULL, -- Полное описание мероприятия
			`start_price` DECIMAL(10, 2) NOT NULL, -- Начальная цена
			`current_price` DECIMAL(10, 2) DEFAULT NULL, -- Текущая цена
			`buy_now_price` DECIMAL(10, 2) DEFAULT NULL, -- Цена "Купить сейчас"
			`start_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время начала аукциона
			`end_date` TIMESTAMP DEFAULT NULL, -- Дата и время окончания аукциона
			`participants` INT DEFAULT NULL, -- Количество подписанных участников
			`capacity` INT DEFAULT NULL, -- Максимальное количество участников
			`status` VARCHAR(50) DEFAULT NULL, -- Статус аукциона (active, completed, canceled)
			`winner` VARCHAR(40) DEFAULT NULL, -- Победитель аукциона
			`bids_count` INT DEFAULT 0, -- Количество ставок
			`views` INT DEFAULT 0, -- Количество просмотров
			`tags` VARCHAR(255) DEFAULT NULL, -- Теги (разделенные запятыми)
			`meta_desc` VARCHAR(300) DEFAULT NULL, -- Мета-описание для SEO
			`meta_keys` TEXT DEFAULT NULL, -- Мета-ключевые слова для SEO
			PRIMARY KEY (`id`) -- Основной ключ
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `lots_fields` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`x_name` VARCHAR(255) NOT NULL, -- Заголовок столбца в таблице
			`column_type` VARCHAR(255) NOT NULL, -- Тип столбца в таблице
			`column_length` INT DEFAULT 0, -- Длина
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `lots_field_values` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`lots_id` INT(11) NOT NULL, -- ID новости
			`field_id` INT(11) NOT NULL, -- ID поля из lots_fields
			`x_value` TEXT NOT NULL, -- Значение поля (универсальное хранилище)
			PRIMARY KEY (`id`),
			FOREIGN KEY (`lots_id`) REFERENCES `lots`(`id`) ON DELETE CASCADE,
			FOREIGN KEY (`field_id`) REFERENCES `lots_fields`(`id`) ON DELETE CASCADE
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `lots_categories` (
			`id` INT(11) NOT NULL AUTO_INCREMENT,
			`parentid` INT(11) DEFAULT NULL,
			`position` INT(11) DEFAULT NULL,
    		`language` VARCHAR(190) DEFAULT NULL,
			`name` VARCHAR(50) DEFAULT NULL,
			`alt_name` VARCHAR(50) DEFAULT NULL,
			`meta_desc` VARCHAR(300) DEFAULT NULL,
			`meta_keys` TEXT DEFAULT NULL,
			`short_tpl` VARCHAR(40) DEFAULT NULL,
			`full_tpl` VARCHAR(40) DEFAULT NULL,
			`comments` TINYINT(1) DEFAULT NULL,
			`views` INT DEFAULT 0,
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `lots_participants` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор записи
			`lots_title` VARCHAR(255) DEFAULT NULL, -- ID аукциона, на которое подписан участник
			`user_id` INT(11) NOT NULL, -- ID пользователя, подписанного на аукцион
			`username` VARCHAR(255) DEFAULT NULL, -- Имя пользователя
			`phone` VARCHAR(20) DEFAULT NULL, -- Телефон пользователя
			`social_url` VARCHAR(255) DEFAULT NULL, -- Сссылка на страницу в соц сети
			`registration_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, -- Дата и время подписки на аукцион
			`status` VARCHAR(50) DEFAULT NULL, -- Статус подписки (например: pending, confirmed, cancelled)
			`ip` VARCHAR(45) DEFAULT NULL, -- IP-адрес пользователя
			`city` VARCHAR(255) DEFAULT NULL, -- Город пользователя
			`notes` TEXT DEFAULT NULL, -- Дополнительные заметки о подписке
			PRIMARY KEY (`id`) -- Основной ключ
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `lots_cat_relations` (
        `lots_id` INT NOT NULL,
        `category_id` INT NOT NULL,
        PRIMARY KEY (`lots_id`, `category_id`),
        CONSTRAINT `fk_lots`
            FOREIGN KEY (`lots_id`) REFERENCES `lots`(`id`)
            ON DELETE CASCADE
            ON UPDATE CASCADE,
        CONSTRAINT `fkl_category`
            FOREIGN KEY (`category_id`) REFERENCES `lots_categories`(`id`)
            ON DELETE CASCADE
            ON UPDATE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;'
];

$createTables = [];
if ($enabledDatabase == "mysql") {
    $createTables = $createTablesMySQL;
} elseif ($enabledDatabase == "pgsql") {
    $createTables = $createTablesPG;
}

// Выполняем запросы на создание таблиц
foreach ($createTables as $sql) {
    if ($db_connect->query($sql) !== TRUE) {
        echo "Ошибка при добавлении данных: " . $db_connect->error . "\n";
        $successFlag = false;
    }
}

$categories = [
    [
        'id' => 1,
        'parentid' => 0,
        'position' => 1,
        'language' => 'Russian',
        'name' => 'Electronics',
        'alt_name' => 'electronics',
        'meta_desc' => '',
        'meta_keys' => '',
        'short_tpl' => 'short_tpl_default',
        'full_tpl' => 'full_tpl_default',
        'comments' => 0,
        'views' => 0
    ],
    [
        'id' => 2,
        'parentid' => 0,
        'position' => 1,
        'language' => 'Russian',
        'name' => 'Home Appliances',
        'alt_name' => 'home-appliances',
        'meta_desc' => '',
        'meta_keys' => '',
        'short_tpl' => 'short_tpl_default',
        'full_tpl' => 'full_tpl_default',
        'comments' => 0,
        'views' => 0
    ]
];

// Массовая вставка данных
$db_connect->insert('lots_categories', $categories);

// Массив с запросами на добавление данных в таблицы
$addData = [
    // Добавление данных в таблицу `lots`
    [
        'author' => 'user1',
        'language' => 'russian',
        'title' => 'Smartphone XYZ',
        'alt_name' => 'lot-1',
        'image' => 'uploads/images/lots/2024/12/smartphone-xyz.jpg',
        'short_desc' => 'Краткое описание лота',
        'full_desc' => 'Полное описание лота',
        'start_price' => 299.99,
        'current_price' => NULL,
        'buy_now_price' => 399.99,
        'start_date' => date('Y-m-d H:i:s'),
        'end_date' => date('Y-m-d H:i:s', strtotime('+7 days')),
        'participants' => 0,
        'capacity' => 40,
        'status' => 'active',
        'tags' => 'smartphone, electronics, gadget',
        'meta_desc' => 'Buy a brand-new smartphone XYZ at lots!',
        'meta_keys' => 'smartphone, lots, electronics'
    ],
    [
        'author' => 'user2',
        'language' => 'russian',
        'title' => 'Vacuum Cleaner Pro',
        'alt_name' => 'lot-2',
        'image' => 'uploads/images/lots/2024/12/vacuum-cleaner-pro.jpg',
        'short_desc' => 'Краткое описание лота',
        'full_desc' => 'Полное описание лота',
        'start_price' => 99.99,
        'current_price' => NULL,
        'buy_now_price' => 149.99,
        'start_date' => date('Y-m-d H:i:s'),
        'end_date' => date('Y-m-d H:i:s', strtotime('+5 days')),
        'participants' => 0,
        'capacity' => 40,
        'status' => 'active',
        'tags' => 'vacuum cleaner, home appliances, cleaning',
        'meta_desc' => 'Get the best vacuum cleaner at the best price!',
        'meta_keys' => 'vacuum cleaner, home, lots'
    ]
];

// Добавление данных
foreach ($addData as $data) {
    $db_connect->insert('lots', $data);
}

	// Проверяем флаг и выводим сообщение
	if ($successFlag) {
		echo "
			<script>
				alert('Данные модуля новостей успешно добавлены');
				window.location.href = window.location.href;
			</script>
		";
		exit();
	}