<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Устанавливаем массив для передачи данных в шаблон
    require_once(ENGINE_DIR . '/data/config.php');

    function allLotsController($lang_code) {
        global $db_connect, $smarty, $config, $lang;
    
        // Получаем номер текущей страницы
        $currentPage = isset($_GET['page']) ? intval($_GET['page']) : 1;
    
        // Рассчитываем с какой записи начать выборку
        $start = ($currentPage - 1) * $config['modules']['lots']['lots_per_page'];

        require_once ENGINE_DIR . '/mods/module_condition_data.php';
        $lotsList = getFilterDataList("lots", $lang_code, $start, [
            "n.start_price", "n.current_price", "n.buy_now_price", "n.start_date",
            "n.end_date", "n.created_at", "n.participants", "n.capacity"
        ]);

        $currentCurrency = getCurrentCurrency();
        $baseCurrency = $config['payment_info']['default_currency'];
        $baseRate = $config['payment_info']['currencies'][$baseCurrency];
        $currentRate = $config['payment_info']['currencies'][$currentCurrency];
        foreach ($lotsList as &$lots) {
            $lots['converted_price'] = convertPrice($lots['start_price'], $baseCurrency, $currentCurrency, $baseRate, $currentRate);
        }
        require_once ENGINE_DIR . '/mods/get_module_categories.php';

        // Для каждого лота получаем категории и их alt_name
        foreach ($lotsList as $key => &$lots) {
            require_once ENGINE_DIR . '/mods/access_control.php';
            $isPermitted = checkAssess((int)$lots["id"], "lots");
            if (!$isPermitted) {
                unset($lotsList[$key]);
                continue;
            }

            $lots['category_alt_names'] = getCategoriesAltNames($lots['id'], "lots");
            $categories = getCategoriesList($lots['id'], "lots");
    
            // Декодируем описания лота аукциона
            if (!empty($lots['short_desc'])) {
                $lots['short_desc'] = html_entity_decode($lots['short_desc'], ENT_QUOTES, 'UTF-8');
            }
    
            if (!empty($lots['full_desc'])) {
                $lots['full_desc'] = html_entity_decode($lots['full_desc'], ENT_QUOTES, 'UTF-8');
            }
        }
        $categoriesDataList = getModuleCategoriesDataList("lots");

        // Функция для подсчета общего числа товаров с учетом языка
        function countEvents($lang_code) {
            global $db_connect;
            $count = $db_connect->count('lots', [
                'language' => $lang_code
            ]);

            return $count;
        }
        
        // Рассчитываем количество страниц для пагинации
        $totalPages = ceil(countEvents($lang_code) / $config['modules']['lots']['lots_per_page']);
        require_once(ENGINE_DIR . '/mods/pagination.php');
    
        // Передаем данные в Smarty
        $smarty->assign('categoriesDataList', $categoriesDataList);
        $smarty->assign('title', $lang['module_name']['lots'] . ' - ' . $config['title']);

        require_once(ENGINE_DIR . '/mods/binding_control.php');
        generateBindings("lots", '<li class="breadcrumb-item active">'. $lang['module_name']['lots'] . '</li>');

        $smarty->assign('currentPage', $currentPage);
        $smarty->assign('totalPages', $totalPages);
        $smarty->assign('pagination', generatePagination($currentPage, $totalPages));
        $smarty->assign('currentCurrency', $currentCurrency);
        $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/modules/lots/' . $config['modules']['lots']['short_tpl'], ['lotsList' => $lotsList]));
    
        // Проверяем, выключен ли сайт
        require_once(ENGINE_DIR . '/mods/offline.php');
    }
    
    $smarty->assign($config);