<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */
	
    require_once(ENGINE_DIR . '/data/dbconfig.php');

	// Флаг для отслеживания успешности выполнения запросов
	$successFlag = true;
$enabledDatabase = $config["database_settings"]["enabled_database"];
$currentDatabaseSettings = $config["database_settings"][$enabledDatabase];
	// Массив с запросами на создание таблиц
	$createTablesPG = [
		'CREATE TABLE IF NOT EXISTS movies (
            id SERIAL PRIMARY KEY,
            autor VARCHAR(40),
            date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            language VARCHAR(190),
            title VARCHAR(255),
            image VARCHAR(255),
            alt_name VARCHAR(190),
            search_id VARCHAR(190),
            year VARCHAR(40),
            quality VARCHAR(50),
            director VARCHAR(100),
            actors VARCHAR(255),
            short_desc TEXT,
            full_desc TEXT,
            meta_desc VARCHAR(300),
            meta_keys TEXT,
            allow_comments BOOLEAN,
            tags VARCHAR(255),
            rating SMALLINT,
            views INT DEFAULT 0
        )',

		'CREATE TABLE IF NOT EXISTS movies_fields (
            id SERIAL PRIMARY KEY, -- Уникальный идентификатор
            x_name VARCHAR(255) NOT NULL, -- Заголовок столбца в таблице
            column_type VARCHAR(255) NOT NULL, -- Тип столбца в таблице
            column_length INT DEFAULT 0 -- Длина
        )',

		'CREATE TABLE IF NOT EXISTS movies_field_values (
            id SERIAL PRIMARY KEY, -- Уникальный идентификатор
            movies_id INT NOT NULL, -- ID новости
            field_id INT NOT NULL, -- ID поля из movies_fields
            x_value TEXT NOT NULL, -- Значение поля (универсальное хранилище)
            FOREIGN KEY (movies_id) REFERENCES movies(id) ON DELETE CASCADE,
            FOREIGN KEY (field_id) REFERENCES movies_fields(id) ON DELETE CASCADE
        )',

		'CREATE TABLE IF NOT EXISTS movies_categories (
            id SERIAL PRIMARY KEY,
            parentid INT,
            position INT,
            language VARCHAR(190),
            name VARCHAR(50),
            alt_name VARCHAR(50),
            meta_desc VARCHAR(300),
            meta_keys TEXT,
            short_tpl VARCHAR(40),
            full_tpl VARCHAR(40),
            comments BOOLEAN,
            views INT DEFAULT 0
        )',

        'CREATE TABLE IF NOT EXISTS movies_cat_relations (
            movies_id INT NOT NULL,
            category_id INT NOT NULL,
            PRIMARY KEY (movies_id, category_id),
            CONSTRAINT fk_movies
                FOREIGN KEY (movies_id) REFERENCES movies(id)
                ON DELETE CASCADE
                ON UPDATE CASCADE,
            CONSTRAINT fkm_category
                FOREIGN KEY (category_id) REFERENCES movies_categories(id)
                ON DELETE CASCADE
                ON UPDATE CASCADE
        );'
	];

$createTablesMySQL = [
    'CREATE TABLE IF NOT EXISTS `movies` (
			`id` INT(11) NOT NULL AUTO_INCREMENT,
			`autor` VARCHAR(40) DEFAULT NULL,
			`date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    		`language` VARCHAR(190) DEFAULT NULL,
			`title` VARCHAR(255) DEFAULT NULL,
			`image` VARCHAR(255) DEFAULT NULL,
			`alt_name` VARCHAR(190) DEFAULT NULL,
			`search_id` VARCHAR(190) DEFAULT NULL,
			`year` VARCHAR(40) DEFAULT NULL,
			`quality` VARCHAR(50) DEFAULT NULL,
			`director` VARCHAR(100) DEFAULT NULL,
			`actors` VARCHAR(255) DEFAULT NULL,
			`short_desc` MEDIUMTEXT DEFAULT NULL,
			`full_desc` MEDIUMTEXT DEFAULT NULL,
			`meta_desc` VARCHAR(300) DEFAULT NULL,
			`meta_keys` TEXT DEFAULT NULL,
			`allow_comments` TINYINT(1) DEFAULT NULL,
			`tags` VARCHAR(255) DEFAULT NULL,
			`rating` TINYINT DEFAULT NULL,
			`views` INT DEFAULT 0,
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `movies_fields` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`x_name` VARCHAR(255) NOT NULL, -- Заголовок столбца в таблице
			`column_type` VARCHAR(255) NOT NULL, -- Тип столбца в таблице
			`column_length` INT DEFAULT 0, -- Длина
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `movies_field_values` (
			`id` INT(11) NOT NULL AUTO_INCREMENT, -- Уникальный идентификатор
			`movies_id` INT(11) NOT NULL, -- ID новости
			`field_id` INT(11) NOT NULL, -- ID поля из movies_fields
			`x_value` TEXT NOT NULL, -- Значение поля (универсальное хранилище)
			PRIMARY KEY (`id`),
			FOREIGN KEY (`movies_id`) REFERENCES `movies`(`id`) ON DELETE CASCADE,
			FOREIGN KEY (`field_id`) REFERENCES `movies_fields`(`id`) ON DELETE CASCADE
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `movies_categories` (
			`id` INT(11) NOT NULL AUTO_INCREMENT,
			`parentid` INT(11) DEFAULT NULL,
			`position` INT(11) DEFAULT NULL,
    		`language` VARCHAR(190) DEFAULT NULL,
			`name` VARCHAR(50) DEFAULT NULL,
			`alt_name` VARCHAR(50) DEFAULT NULL,
			`meta_desc` VARCHAR(300) DEFAULT NULL,
			`meta_keys` TEXT DEFAULT NULL,
			`short_tpl` VARCHAR(40) DEFAULT NULL,
			`full_tpl` VARCHAR(40) DEFAULT NULL,
			`comments` TINYINT(1) DEFAULT NULL,
			`views` INT DEFAULT 0,
			PRIMARY KEY (`id`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8',

    'CREATE TABLE IF NOT EXISTS `movies_cat_relations` (
        `movies_id` INT NOT NULL,
        `category_id` INT NOT NULL,
        PRIMARY KEY (`movies_id`, `category_id`),
        CONSTRAINT `fk_movies`
            FOREIGN KEY (`movies_id`) REFERENCES `movies`(`id`)
            ON DELETE CASCADE
            ON UPDATE CASCADE,
        CONSTRAINT `fkm_category`
            FOREIGN KEY (`category_id`) REFERENCES `movies_categories`(`id`)
            ON DELETE CASCADE
            ON UPDATE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;'
];

$createTables = [];
if ($enabledDatabase == "mysql") {
    $createTables = $createTablesMySQL;
} elseif ($enabledDatabase == "pgsql") {
    $createTables = $createTablesPG;
}


// Выполняем запросы на создание таблиц
	foreach ($createTables as $sql) {
		if ($db_connect->query($sql) !== TRUE) {
			echo "Ошибка при добавлении данных: " . $db_connect->error . "\n";
			$successFlag = false;
		}
	}

	// Массив с запросами на добавление данных в таблицы
	$addData = [
		// Добавление данных в таблицу `movies`
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (1, 'Admin', NOW(), 'Сериалы, Драмы, Комедии', 'Russian', 'Бесстыжие', '/uploads/images/movies/2024/2/1/image.webp', 'shameless', '571335', '2011', 'FHD (1080)', 'Иэн Б. МакДональд, Марк Майлод, Кристофер Чулак', 'Уильям Х. Мэйси, Итан Каткоски, Джереми Аллен Уайт, Шанола Хэмптон, Стив Хоуи, Эмма Кинни, Камерон Монахэн, Эмми Россам, Майкл Патрик Макгилл, Ноэль Фишер', 'Краткое описание фильма № 1', 'Американский ремейк британского Сериалыа, повествующий о взбалмошной многодетной семье Галлахеров и их соседях, которые веселятся,попадают в самые невероятные ситуации и пытаются выжить в этом мире всеми возможными средствами, но при этом как можно меньше работая.', '1', '1', '1', 'series, comedy', '8', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (2, 'Admin', NOW(), 'Драмы, Мелодрамы', 'Russian', 'Секрет', '/uploads/images/movies/2024/2/2/image.webp', 'secret', '1196157', '2018', 'FHD (1080)', 'Энди Теннант', 'Кэти Холмс, Джош Лукас, Селия Уэстон, Джерри ОКоннелл, Сара Хоффмайстер, Эйдан Пирс Бреннан, Хлоя Ли, Катрина Бегин, Сидни Теннант, Йоханс Майлс', 'Краткое описание фильма № 2', 'Когда сильный шторм разрушает дом молодой вдовы с тремя детьми, на пороге появляется таинственный незнакомец. Всего за несколько дней загадочный гость объединяет семью и помогает им найти новый смысл в жизни. Он открывает им Секрет, который может изменить все.', '1', '1', '1', 'comedy, romance', '7', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (3, 'Admin', NOW(), 'Драмы, Триллеры, Фантастика, Ужасы', 'Russian', 'Я-легенда', '/uploads/images/movies/2024/2/3/image.webp', 'movie-3', '195524', '2007', 'FHD (1080)', 'Френсис Лоуренс', 'Уилл Смит, Алиси Брага, Чарли Тахэн, Салли Ричардсон-Уитфилд, Уиллоу Смит, Даррел Фостер, Эйприл Грэйс, Дэш Майок, Джоанна Нумата, Abbey', 'Краткое описание фильма № 3', 'Неизвестный вирус унёс жизни половины населения земного шара, а остальную половину превратил в вампиров. Единственный уцелевший человек с иммунитетом к заболеванию ночами держит осаду упырей, а днем пытается найти противоядие и докопаться до причин эпидемии.', '1', '1', '1', 'sci-fi, thriller', '9', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (4, 'Admin', NOW(), 'Боевики, Триллеры', 'Russian', 'Пчеловод', '/uploads/images/movies/2024/2/4/image.webp', 'movie-4', '4626783', '2024', 'FHD (1080)', 'Дэвид Эйр', 'Джейсон Стэйтем, Джош Хатчерсон, Минни Драйвер, Джереми Айронс, Эмми Рэвер-Лэмпман, Филисия Рашад, Энцо Чиленти, Ли Дань, Тейлор Джеймс, Адам Бейзил', 'Краткое описание фильма № 3', 'Главный герой, одержимый местью одиночка и бывший оперативник из влиятельной и засекреченной организации под кодовым названием «Пчеловоды».', '1', '1', '1', 'sci-fi, thriller', '9', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (5, 'Admin', NOW(), 'Фантастика, Боевики, Приключения', 'Russian', 'Аквамен и потерянное царство', '/uploads/images/movies/2024/2/5/image.webp', 'movie-5', '1234997', '2023', 'FHD (1080)', 'Джеймс Ван', 'Джейсон Момоа, Патрик Уилсон, Яхья Абдул-Матин II, Дольф Лундгрен, Темуэра Моррисон, Николь Кидман, Яни Жао, Эмбер Хёрд, Винсент Риган, Рэндалл Пак', 'Краткое описание фильма № 3', 'Аквамен наконец обрел спокойную семейную жизнь с супругой Мерой и новорожденным сыном Артуром- младшим. Как царю Атлантиды ему приходится искать компромиссы с другими официальными лицами, отвергающими его грандиозные идеи. Побежденный суперзлодей Черная Манта все еще лелеет мечты отомстить за своего погибшего отца и планирует разрушить Атлантиду с помощью таинственного артефакта.', '1', '1', '1', 'sci-fi, thriller', '9', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (6, 'Admin', NOW(), 'Боевики, Триллеры', 'Russian', 'Дом у дороги', '//avatars.mds.yandex.net/get-kinopoisk-image/10809116/20b0b26f-60d9-4990-bd57-963d1ead27f8/300x450', '817167', '817167', '2024', 'FHD (1080)', 'Даг Лайман', 'Джессика Уильямс, Конор Макгрегор, Джейк Джилленхол, Би Кей Кэннон, Артуро Кастро, Билли Магнуссен, Лукас Гейдж, Доминик Коламбус, Даниэла Мелшиор, Жоакин де Алмейда', 'Краткое описание фильма № 3', 'Большую часть сознательной жизни персонаж проработал вышибалой, пользующимся популярностью в родном городе. Ныне же он странствует по стране и не только, выполняя задания нуждающихся, взамен получая приятные, денежные суммы. В этот раз Далтон оказывается в американском городке, находящемся у чёрта на куличиках. В баре «Две двойки» ему будет поручено новое задание — местный рэкетир и гангстер в край обнаглел и его предстоит как следует выпотрошить, чтобы он никогда вновь не переступил порог сего прекрасного заведения.', '1', '1', '1', 'sci-fi, thriller', '9', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (7, 'Admin', NOW(), 'Боевики, Драмы', 'Russian', 'Мятежная Луна, часть 1: Дитя огня', '/uploads/images/movies/2024/2/7/image.webp', 'movie-7', '4538172', '2023', 'FHD (1080)', 'Зак Снайдер', 'София Бутелла, Эд Скрейн, Михил Хёйсман, Чарли Ханнэм, Пэ Ду-на, Джимон Хонсу, Рэй Фишер, Клеопатра Коулмэн, Фра Фи', 'Краткое описание фильма № 3', 'В далеком будущем единое правительство сосредотачивает в своих руках всю власть над другими планетами. Оно опирается на сильную армию, жестоко подавляющую любое сопротивление. Корабль главной героини Коры, путешествующей в космосе, терпит крушение, в результате чего девушка оказывается на одной планете, где жители заняты фермерством и ведут спокойный размеренный образ жизни. Но однажды по приказу генерала сюда прилетают солдаты с заданием подчинить себе новую планету.', '1', '1', '1', 'sci-fi, thriller', '9', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (8, 'Admin', NOW(), 'Фантастика, Приключения', 'Russian', 'Марсианин', '//avatars.mds.yandex.net/get-kinopoisk-image/1900788/6f631486-e947-487d-94d6-41c2b5a8f5a0/300x450', '841700', '841700', '2015', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (9, 'Admin', NOW(), 'Фантастика, Боевики, Триллеры, Драмы', 'Russian', 'Исходный код', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/789dbe50-6884-4f27-a997-bb78d5f0df42/300x450', '409295', '409295', '2011', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (10, 'Admin', NOW(), 'Фантастика, Боевики, Приключения, Комедии', 'Russian', 'Стражи Галактики. Часть 2', '//avatars.mds.yandex.net/get-kinopoisk-image/1600647/ea4ff704-113d-46de-b6b4-03176ac95118/300x450', '841263', '841263', '2017', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (11, 'Admin', NOW(), 'Триллеры, Драмы, Криминал, Детективы', 'Russian', 'Пленницы', '//avatars.mds.yandex.net/get-kinopoisk-image/1900788/c7debfa6-6264-4352-a996-3676906cce58/300x450', '455194', '455194', '2013', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (12, 'Admin', NOW(), 'Фантастика, Боевики, Триллеры, Драмы', 'Russian', 'Бегущий по лезвию 2049', '//avatars.mds.yandex.net/get-kinopoisk-image/1898899/33dbf977-208f-448c-8726-d2fafdcced28/300x450', '589290', '589290', '2017', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (13, 'Admin', NOW(), 'Мультфильмы, Фантастика, Комедии, Криминал, Приключения, Семейные', 'Russian', 'Гадкий я', '//avatars.mds.yandex.net/get-kinopoisk-image/1900788/ae11375b-68ad-4bf7-98d2-127d83e09381/300x450', '432724', '432724', '2010', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (14, 'Admin', NOW(), 'Детективы, Драмы, Триллеры', 'Russian', 'Дело Коллини', '//avatars.mds.yandex.net/get-kinopoisk-image/1704946/51ab24d3-f297-4353-9a91-4ec1c79f3789/300x450', '1179501', '1179501', '2019', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (15, 'Admin', NOW(), 'Мультфильмы, Драмы, Комедии, Приключения, Семейные', 'Russian', 'Лука', '//avatars.mds.yandex.net/get-kinopoisk-image/4483445/6ad6cf7f-c95e-48b1-9949-ccf0c29b8f7d/300x450', '1395801', '1395801', '2021', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (16, 'Admin', NOW(), 'Мультфильмы, Фантастика, Боевики, Комедии, Приключения, Семейные', 'Russian', 'Вперёд', '//avatars.mds.yandex.net/get-kinopoisk-image/1946459/442dc4a0-a101-46aa-aa9f-79678f92a5d7/300x450', '1080513', '1080513', '2019', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (17, 'Admin', NOW(), 'Драмы, Мелодрамы', 'Russian', 'Виноваты звезды', '//avatars.mds.yandex.net/get-kinopoisk-image/1773646/ebd2268f-f0cc-4de5-95aa-1c1013597aa5/300x450', '724703', '724703', '2014', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (18, 'Admin', NOW(), 'Драмы, Семейные', 'Russian', 'Хайди', '//avatars.mds.yandex.net/get-kinopoisk-image/1898899/478f8055-d527-462a-bc8f-85cfb92d3755/300x450', '848086', '848086', '2015', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (19, 'Admin', NOW(), 'Фантастика, Боевики', 'Russian', 'Лига справедливости Зака Снайдера', '//avatars.mds.yandex.net/get-kinopoisk-image/6201401/3518c34c-092f-42bf-b948-87ebe0bd325a/300x450', '1387021', '1387021', '2021', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (20, 'Admin', NOW(), 'Боевики, Триллеры, Драмы, История', 'Russian', 'Отель Мумбаи: Противостояние', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/7192c98b-570d-4787-8a65-dbe373c404a1/300x450', '958519', '958519', '2018', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (21, 'Admin', NOW(), 'Драмы, Приключения', 'Russian', 'Жизнь Пи', '//avatars.mds.yandex.net/get-kinopoisk-image/1600647/f340727d-6aae-4b24-bcdc-f692e0e832e6/300x450', '158786', '158786', '2012', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (22, 'Admin', NOW(), 'Боевики, Фантастика, Приключения', 'Russian', 'Безумный Макс: Дорога ярости', '//avatars.mds.yandex.net/get-kinopoisk-image/1629390/72ba01f5-4cb3-49b6-9dd5-1edffe4411d5/300x450', '453406', '453406', '2015', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (23, 'Admin', NOW(), 'Фантастика, Боевики, Приключения, Комедии', 'Russian', 'Стражи Галактики', '//avatars.mds.yandex.net/get-kinopoisk-image/1773646/2e6ab20b-7cf1-49e7-b465-bd5a71c13fa3/300x450', '689066', '689066', '2014', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (24, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'История игрушек: Большой побег', '//avatars.mds.yandex.net/get-kinopoisk-image/1900788/f2848b86-dfe5-4273-8593-94ca3456830c/300x450', '258328', '258328', '2010', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (25, 'Admin', NOW(), 'Боевики, Приключения, Триллеры, Криминал, Детективы', 'Russian', 'Шерлок Холмс: Игра теней', '//avatars.mds.yandex.net/get-kinopoisk-image/1773646/27b4bcbe-4048-4362-8e40-b9b42e0ef1c2/300x450', '474953', '474953', '2011', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (26, 'Admin', NOW(), 'Фантастика, Боевики, Драмы, Приключения', 'Russian', 'Мстители: Финал', '//avatars.mds.yandex.net/get-kinopoisk-image/1600647/ae22f153-9715-41bb-adb4-f648b3e16092/300x450', '843650', '843650', '2019', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (27, 'Admin', NOW(), 'Мелодрамы', 'Russian', 'Мальчик-оборотень', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/029f7998-eb4f-41da-84eb-8c76a079b142/300x450', '695489', '695489', '2012', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (28, 'Admin', NOW(), 'Драмы, Криминал', 'Russian', 'Опасная игра Слоун', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/f454d3cb-cbde-4045-8a89-fb8cb357ae09/300x450', '933307', '933307', '2016', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (29, 'Admin', NOW(), 'Фантастика, Боевики, Приключения', 'Russian', 'Мстители', '//avatars.mds.yandex.net/get-kinopoisk-image/1898899/972b7f43-9677-40ce-a9bc-02a88ad3919d/300x450', '263531', '263531', '2012', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (30, 'Admin', NOW(), 'Приключения, Семейные', 'Russian', 'Гарри Поттер и Дары Смерти: Часть I', '//avatars.mds.yandex.net/get-kinopoisk-image/6201401/66852969-2d21-45de-bae1-62ec7760f756/300x450', '276762', '276762', '2010', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (31, 'Admin', NOW(), 'Фантастика, Драмы, Мелодрамы, Комедии', 'Russian', 'Бойфренд из будущего', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/9b9a887c-cd32-44b4-bcea-4fab2fa3bf8e/300x450', '662596', '662596', '2013', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (32, 'Admin', NOW(), 'Фантастика, Боевики, Приключения', 'Russian', 'Человек-паук: Нет пути домой', '//avatars.mds.yandex.net/get-kinopoisk-image/6201401/731c4031-7389-44f4-8c15-f9f4e3b0ed90/300x450', '1309570', '1309570', '2021', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (33, 'Admin', NOW(), 'Комедии, Приключения, Детективы, Криминал', 'Russian', 'Отель «Гранд Будапешт»', '//avatars.mds.yandex.net/get-kinopoisk-image/1629390/ea08a062-81a9-46e9-a475-e49388216eea/300x450', '683999', '683999', '2014', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (34, 'Admin', NOW(), 'Драмы', 'Russian', 'Охота', '//avatars.mds.yandex.net/get-kinopoisk-image/1900788/b97af3b9-41b5-4e1d-a59c-051e4e979e80/300x450', '647671', '647671', '2012', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (35, 'Admin', NOW(), 'Драмы', 'Russian', 'Невозможное', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/bd3882d7-c0d1-4d67-bc13-a9aa47178d35/300x450', '518037', '518037', '2012', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (36, 'Admin', NOW(), 'Драмы', 'Russian', 'Одаренная', '//avatars.mds.yandex.net/get-kinopoisk-image/4774061/b12972ef-0eac-4685-99b0-ac038f844127/300x450', '929348', '929348', '2017', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (37, 'Admin', NOW(), 'Мультфильмы, Боевики, Драмы, Комедии, Приключения, Семейные', 'Russian', 'Хранители снов', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/c6d5650b-1c39-4946-86f8-460220ee1949/300x450', '466581', '466581', '2012', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (38, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Как приручить дракона 2', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/929283bf-9ae9-422f-9ac2-edf5d3e16aea/300x450', '512883', '512883', '2014', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (39, 'Admin', NOW(), 'Криминал, Триллеры, Драмы, Детективы', 'Russian', 'Омерзительная восьмерка', '//avatars.mds.yandex.net/get-kinopoisk-image/1600647/e5013408-8374-400b-a444-b9753e9da28d/300x450', '819101', '819101', '2015', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (40, 'Admin', NOW(), 'Драмы, История', 'Russian', 'Землетрясение', '//avatars.mds.yandex.net/get-kinopoisk-image/4774061/42571afc-b3f9-4f95-915d-00acd154e6b4/300x450', '463694', '463694', '2010', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (41, 'Admin', NOW(), 'Драмы, Криминал, Триллеры', 'Russian', 'Джокер', '//avatars.mds.yandex.net/get-kinopoisk-image/1946459/84934543-5991-4c93-97eb-beb6186a3ad7/300x450', '1048334', '1048334', '2019', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (42, 'Admin', NOW(), 'Триллеры, Драмы, Фантастика', 'Russian', 'Области тьмы', '//avatars.mds.yandex.net/get-kinopoisk-image/1629390/d3bfd32d-41b4-48ad-9584-b3fc1f5669d4/300x450', '462606', '462606', '2011', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (43, 'Admin', NOW(), 'Боевики, Драмы, История', 'Russian', 'RRR: Рядом ревёт революция', '//avatars.mds.yandex.net/get-kinopoisk-image/4303601/1a184eb2-a345-43ff-a7a0-f3b7884f3922/300x450', '1115117', '1115117', '2022', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (44, 'Admin', NOW(), 'Приключения, Боевики', 'Russian', 'Хоббит: Пустошь Смауга', '//avatars.mds.yandex.net/get-kinopoisk-image/6201401/dd195023-81e0-42bc-9b33-e86ac8abf30e/300x450', '408876', '408876', '2013', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (45, 'Admin', NOW(), 'Драмы', 'Russian', 'Воин', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/ae52ff2c-c065-415d-8554-15904681707a/300x450', '442568', '442568', '2011', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (46, 'Admin', NOW(), 'Комедии, Семейные', 'Russian', 'Приключения Паддингтона 2', '//avatars.mds.yandex.net/get-kinopoisk-image/6201401/cd9d3979-bf12-4e73-9ebc-0ba2f1474aa4/300x450', '906042', '906042', '2017', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (47, 'Admin', NOW(), 'Мультфильмы, Семейные, Комедии', 'Russian', 'Головоломка', '//avatars.mds.yandex.net/get-kinopoisk-image/4303601/fe96f444-f022-4d14-a40f-7c1f35cc6ab8/300x450', '645118', '645118', '2015', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (48, 'Admin', NOW(), 'Фантастика, Боевики, Приключения', 'Russian', 'Мстители: Война бесконечности', '//avatars.mds.yandex.net/get-kinopoisk-image/1773646/af92d310-4ae5-4daa-b42c-5bcc380c2e6e/300x450', '843649', '843649', '2018', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (49, 'Admin', NOW(), 'Мультфильмы, Боевики, Драмы, Комедии, Приключения, Семейные', 'Russian', 'Райя и последний дракон', '//avatars.mds.yandex.net/get-kinopoisk-image/6201401/1d5ebdef-0397-4fa0-a80a-80a28bf6efc6/300x450', '1015471', '1015471', '2021', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (50, 'Admin', NOW(), 'Мультфильмы, Фантастика, Драмы, Приключения, Семейные', 'Russian', 'Маленький принц', '//avatars.mds.yandex.net/get-kinopoisk-image/1777765/12c55cfe-7d27-4c95-9f91-b64cbb7d5b64/300x450', '572553', '572553', '2015', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (51, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения', 'Russian', 'Кот в сапогах 2: Последнее желание', '//avatars.mds.yandex.net/get-kinopoisk-image/4303601/19b2a831-d81b-4364-a82a-dc6ca779023f/300x450', '840821', '840821', '2022', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (52, 'Admin', NOW(), 'Детективы, Комедии, Драмы, Криминал', 'Russian', 'Достать ножи', '//avatars.mds.yandex.net/get-kinopoisk-image/1777765/bb8afbd6-c9cd-4631-99e9-3fecf241dbaf/300x450', '1188529', '1188529', '2019', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (53, 'Admin', NOW(), 'Приключения, Боевики', 'Russian', 'Хоббит: Нежданное путешествие', '//avatars.mds.yandex.net/get-kinopoisk-image/4303601/0e569ebd-0639-416b-92c5-2afffbd5d089/300x450', '278522', '278522', '2012', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (54, 'Admin', NOW(), 'Фантастика, Боевики, Комедии, Приключения', 'Russian', 'Стражи Галактики. Часть 3', '//avatars.mds.yandex.net/get-kinopoisk-image/6201401/7c39a0ca-7319-4442-a412-d3127523f6c0/300x450', '1044280', '1044280', '2023', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (55, 'Admin', NOW(), 'Драмы, Семейные', 'Russian', 'Чудо', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/926f01c6-f373-415a-b6ca-42b027757d36/300x450', '722951', '722951', '2017', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (56, 'Admin', NOW(), 'Драмы, Криминал', 'Russian', 'Три билборда на границе Эббинга, Миссури', '//avatars.mds.yandex.net/get-kinopoisk-image/6201401/9a78d4ef-5b3b-49e5-9390-735167d01fdf/300x450', '944098', '944098', '2017', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (57, 'Admin', NOW(), 'Драмы', 'Russian', 'Капернаум', '//avatars.mds.yandex.net/get-kinopoisk-image/1946459/64ff8863-552e-4158-b4ea-e31a1c223989/300x450', '1118042', '1118042', '2018', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (58, 'Admin', NOW(), 'Детективы, Приключения, Семейные', 'Russian', 'Гарри Поттер и Дары Смерти: Часть II', '//avatars.mds.yandex.net/get-kinopoisk-image/4303601/82b5cc4a-18c7-4180-a98a-0c96528d63dd/300x450', '407636', '407636', '2011', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (59, 'Admin', NOW(), 'Фантастика, Боевики, Триллеры, Драмы, Криминал', 'Russian', 'Темный рыцарь: Возрождение легенды', '//avatars.mds.yandex.net/get-kinopoisk-image/1600647/78a50ddd-1712-4bb0-869e-680963c1580e/300x450', '437410', '437410', '2012', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (60, 'Admin', NOW(), 'Боевики, Драмы, Комедии', 'Russian', 'Джанго освобожденный', '//avatars.mds.yandex.net/get-kinopoisk-image/1898899/401c67e4-5047-42c2-8668-aeda39da529f/300x450', '586397', '586397', '2012', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (61, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Как приручить дракона', '//avatars.mds.yandex.net/get-kinopoisk-image/4774061/1a920451-e765-41e9-81aa-78438e82abbc/300x450', '280172', '280172', '2010', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (62, 'Admin', NOW(), 'Мультфильмы, Комедии, Криминал, Детективы, Приключения, Семейные', 'Russian', 'Зверополис', '//avatars.mds.yandex.net/get-kinopoisk-image/4716873/893bba73-3105-4944-8d18-a38f929f2759/300x450', '775276', '775276', '2016', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (63, 'Admin', NOW(), 'Драмы', 'Russian', 'Одержимость', '//avatars.mds.yandex.net/get-kinopoisk-image/6201401/16af46be-bcfe-461e-af54-ff17b905b82e/300x450', '725190', '725190', '2013', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (64, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Душа', '//avatars.mds.yandex.net/get-kinopoisk-image/4774061/ce2e470c-861c-4995-b6b1-54e1dd4932d4/300x450', '775273', '775273', '2020', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (65, 'Admin', NOW(), 'Криминал, Комедии, Боевики', 'Russian', 'Джентльмены', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/637271d5-61b4-4e46-ac83-6d07494c7645/300x450', '1143242', '1143242', '2019', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (66, 'Admin', NOW(), 'Фантастика, Драмы, Приключения', 'Russian', 'Интерстеллар', '//avatars.mds.yandex.net/get-kinopoisk-image/1600647/430042eb-ee69-4818-aed0-a312400a26bf/300x450', '258687', '258687', '2014', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (67, 'Admin', NOW(), 'Мультфильмы, Семейные, Комедии, Приключения', 'Russian', 'Клаус', '//avatars.mds.yandex.net/get-kinopoisk-image/1773646/279f9f19-6a29-4fae-935e-54ddf80c653b/300x450', '957887', '957887', '2019', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (68, 'Admin', NOW(), 'Фантастика, Боевики, Триллеры, Драмы, Детективы', 'Russian', 'Начало', '//avatars.mds.yandex.net/get-kinopoisk-image/1629390/8ab9a119-dd74-44f0-baec-0629797483d7/300x450', '447301', '447301', '2010', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (69, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Тайна Коко', '//avatars.mds.yandex.net/get-kinopoisk-image/1946459/6e11a16e-c9e7-491f-9162-01098a7d8dd9/300x450', '679486', '679486', '2017', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (70, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Моана', '//avatars.mds.yandex.net/get-kinopoisk-image/1600647/f06aa25d-2f76-4bac-8d12-29436fd589bc/300x450', '837530', '837530', '2016', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (71, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Рапунцель: Запутанная История', '//avatars.mds.yandex.net/get-kinopoisk-image/4303601/780ecf39-c5d5-482f-bf27-d51d6f8055fb/300x450', '84049', '84049', '2010', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (72, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Как приручить дракона 3', '//avatars.mds.yandex.net/get-kinopoisk-image/1773646/6fd80e9f-ee41-470a-a487-3730f7ded41c/300x450', '706655', '706655', '2019', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (73, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'История игрушек 4', '//avatars.mds.yandex.net/get-kinopoisk-image/1900788/a622cbc9-9030-404f-a284-134b8ba2d67e/300x450', '846824', '846824', '2019', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (74, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Элементарно', '//avatars.mds.yandex.net/get-kinopoisk-image/6201401/16b1819e-47f7-4fcd-bcdd-4645149cd74b/300x450', '4889667', '4889667', '2023', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (75, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Университет монстров', '//avatars.mds.yandex.net/get-kinopoisk-image/1777765/7c96c32b-c0b1-467a-afe3-b21825ddc1bd/300x450', '468904', '468904', '2013', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (76, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Семейка Крудс', '//avatars.mds.yandex.net/get-kinopoisk-image/1600647/9df6f2a7-236a-4836-bcee-f1f97dcc58ac/300x450', '198116', '198116', '2013', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (77, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Храбрая сердцем', '//avatars.mds.yandex.net/get-kinopoisk-image/1629390/2d503116-1507-4d23-bffe-cc4096b4f586/300x450', '409118', '409118', '2012', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (78, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Кунг-фу Панда', '//avatars.mds.yandex.net/get-kinopoisk-image/1900788/a9c4698d-7eea-4fe8-8624-4c536c09f7fd/300x450', '103734', '103734', '2008', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (79, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Кунг-фу Панда 2', '//avatars.mds.yandex.net/get-kinopoisk-image/1898899/6f8602bd-3058-40f2-911b-e16b68a634b6/300x450', '427878', '427878', '2011', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (80, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Кунг-фу Панда 3', '//avatars.mds.yandex.net/get-kinopoisk-image/1946459/52d6e21c-68d2-44eb-80b3-ed572c7bdc85/300x450', '692865', '692865', '2016', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (81, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Кунг-фу Панда 4', '//avatars.mds.yandex.net/get-kinopoisk-image/9784475/6f8c20ab-d744-4ac3-9d5a-ac15942eb4eb/300x450', '5078842', '5078842', '2024', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (82, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Книга джунглей', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/637cb0b2-2cb5-4df3-bd53-01f08e5594b5/300x450', '779024', '779024', '2016', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (83, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Балерина', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/e999bca9-8b7a-4027-b8a6-c021b2095332/300x450', '674249', '674249', '2016', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (84, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Шрэк', '//avatars.mds.yandex.net/get-kinopoisk-image/1946459/7ade06a8-4178-4386-9ee2-87fec5a172eb/300x450', '430', '430', '2001', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (85, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Шрэк 2', '//avatars.mds.yandex.net/get-kinopoisk-image/1773646/27a3c989-e883-40f3-806f-f3ef27fe7177/300x450', '5273', '5273', '2004', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (86, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Шрэк 3', '//avatars.mds.yandex.net/get-kinopoisk-image/1900788/3e76a63d-16ba-4609-a691-41358270e93d/300x450', '84020', '84020', '2007', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (87, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Шрэк навсегда', '//avatars.mds.yandex.net/get-kinopoisk-image/1704946/ef538202-561a-4f47-a11b-87ea842d92da/300x450', '271806', '271806', '2010', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (88, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Король Лев', '//avatars.mds.yandex.net/get-kinopoisk-image/1704946/60aa1abc-b754-4817-ad9c-0bcda427a12b/300x450', '2360', '2360', '1994', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (89, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Король Лев 2: Гордость Симбы', '//avatars.mds.yandex.net/get-kinopoisk-image/1629390/429397cd-5bdb-4814-afda-9e1d9b39451a/300x450', '77038', '77038', '1998', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (90, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Король Лев 3: Акуна Матата', '//avatars.mds.yandex.net/get-kinopoisk-image/1900788/b97e7837-4708-408f-9762-071faf6c1886/300x450', '77040', '77040', '2004', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (91, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Рататуй', '//avatars.mds.yandex.net/get-kinopoisk-image/1773646/894f7e3c-cedf-4e5c-946a-9021efdf17dd/300x450', '89514', '89514', '2007', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (92, 'Admin', NOW(), 'Мультфильмы, Семейные, Комедии', 'Russian', 'Головоломка 2', '//avatars.mds.yandex.net/get-kinopoisk-image/10592371/edf3f2a3-47e4-402a-80b4-3688e2b59fc9/300x450', '5102255', '5102255', '2024', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (93, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'В поисках Немо', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/58e6b27d-a443-4ca7-a90f-a6fa968dfe25/300x450', '7908', '7908', '2003', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (94, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Миньоны', '//avatars.mds.yandex.net/get-kinopoisk-image/1600647/a609cedc-7f75-4cb3-9e60-a5735c0c741b/300x450', '694051', '694051', '2015', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (95, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Миньоны: Грювитация', '//avatars.mds.yandex.net/get-kinopoisk-image/4774061/e2d51a11-7a60-41e6-abc6-a0b73b99f148/300x450', '1009513', '1009513', '2022', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (96, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Гадкий я 2', '//avatars.mds.yandex.net/get-kinopoisk-image/4303601/4030a2d4-7ef3-45bc-bdeb-7f0a072d2a13/300x450', '550910', '550910', '2013', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (97, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Гадкий я 3', '//avatars.mds.yandex.net/get-kinopoisk-image/1946459/a2fb3e6e-0266-430d-99ab-fe8a1f799555/300x450', '820599', '820599', '2017', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (98, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Гадкий я 4', '//avatars.mds.yandex.net/get-kinopoisk-image/10592371/9bbbce98-ce02-4f5e-bfc0-e20e1a72533a/300x450', '1073122', '1073122', '2024', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (99, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Холодное сердце', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/efa923ca-2007-4a79-b759-377fc1a5664f/300x450', '493208', '493208', '2013', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (100, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Холодное сердце 2', '//avatars.mds.yandex.net/get-kinopoisk-image/1704946/0c2824a3-910f-476b-a657-06f6e2da13b1/300x450', '903831', '903831', '2019', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (101, 'Admin', NOW(), 'Мультфильмы, Комедии, Приключения, Семейные', 'Russian', 'Удача', '//avatars.mds.yandex.net/get-kinopoisk-image/4774061/baebd06c-ac30-4ff9-b6ca-79d3bb1c57d1/300x450', '1087904', '1087904', '2022', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (102, 'Admin', NOW(), 'Боевики, Приключения, Фантастика', 'Russian', 'Чудо-женщина', '//avatars.mds.yandex.net/get-kinopoisk-image/1600647/2efdd5e7-feb8-4394-b473-a4ffd661d21f/300x450', '1046969', '1046969', '2020', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (103, 'Admin', NOW(), 'Боевики, Приключения, Фантастика', 'Russian', 'Чудо-женщина: 1984', '//avatars.mds.yandex.net/get-kinopoisk-image/1773646/de30cec1-c90e-4d7a-b7e7-4b5db3bdf02c/300x450', '102383', '102383', '2017', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (104, 'Admin', NOW(), 'Фантастика, Боевики, Приключения', 'Russian', 'Грань будущего', '//avatars.mds.yandex.net/get-kinopoisk-image/1704946/59acece0-e900-4914-aa8a-ec5f42026a64/300x450', '505851', '505851', '2014', '', 'Даг Лайман', 'Том Круз, Эмили Блант, Билл Пэкстон, Брендан Глисон, Ноа Тейлор, Джонас Армстронг, Тони Вэй, Кик Гарри, Франц Драмех, Драгомир Мрсич', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (105, 'Admin', NOW(), 'Фантастика, Боевики, Приключения', 'Russian', 'Время', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/02d70d58-ae4e-4ef4-b886-c215e9e99436/300x450', '517988', '517988', '2011', '', 'Эндрю Никкол', 'Джастин Тимберлейк, Аманда Сайфред, Киллиан Мерфи, Алекс Петтифер, Винсент Картайзер, Оливия Уайлд, Мэтт Бомер, Джонни Галэки, Коллинз Пенни, Итан Пек', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (106, 'Admin', NOW(), 'Фантастика, Боевики, Триллеры', 'Russian', 'Терминатор', '//avatars.mds.yandex.net/get-kinopoisk-image/1600647/537869cd-5fb8-4993-af4c-c5f6a30e61ba/300x450', '507', '507', '1984', '', 'Джеймс Кэмерон', 'Арнольд Шварценеггер, Майкл Бин, Линда Хэмилтон, Пол Уинфилд, Лэнс Хенриксен, Рик Россович, Бесс Мотта, Эрл Боэн, Дик Миллер, Шон Шеппс', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (107, 'Admin', NOW(), 'Фантастика, Боевики, Триллеры', 'Russian', 'Терминатор 2: Судный день', '//avatars.mds.yandex.net/get-kinopoisk-image/1704946/ade65029-952f-488d-87b2-20c676970151/300x450', '444', '444', '1991', '', 'Джеймс Кэмерон', 'Арнольд Шварценеггер, Линда Хэмилтон, Эдвард Ферлонг, Роберт Патрик, Эрл Боэн, Джо Мортон, С. Ипейта Меркерсон, Кастуло Герра, Дэнни Кукси, Дженетт Голдстин', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (108, 'Admin', NOW(), 'Фантастика, Боевики, Триллеры', 'Russian', 'Терминатор 3: Восстание машин', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/eb157a95-c1fa-4426-8eab-90653e848923/300x450', '319', '319', '2003', '', 'Джонатан Мостоу', 'Арнольд Шварценеггер, Ник Стал, Клэр Дэйнс, Кристанна Локен, Дэвид Эндрюс, Марк Фамильетти, Эрл Боэн, Мойра Харрис, Чоппер Бернет, Кристофер Лоуфорд', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (109, 'Admin', NOW(), 'Фантастика, Боевики, Приключения', 'Russian', 'Терминатор: Да придёт спаситель', '//avatars.mds.yandex.net/get-kinopoisk-image/1629390/12ed8842-8bd2-4450-a928-38f58d0af6ab/300x450', '160932', '160932', '2009', '', 'МакДжи', 'Кристиан Бэйл, Сэм Уортингтон, Антон Ельчин, Мун Бладгуд, Брайс Даллас Ховард, Коммон, Джейн Александр, Майкл Айронсайд, Иван Г’Вера, Крис Браунинг', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (110, 'Admin', NOW(), 'Фантастика, Боевики, Триллеры', 'Russian', 'Терминатор: Генезис', '//avatars.mds.yandex.net/get-kinopoisk-image/1600647/f95213be-107a-4632-843b-6a4e3e525d59/300x450', '436225', '436225', '2015', '', 'Алан Тейлор', 'Арнольд Шварценеггер, Джейсон Кларк, Эмилия Кларк, Джай Кортни, Дж.К. Симмонс, Дайо Окенийи, Мэтт Смит, Кортни Б. Вэнс, Ли Бён-хон, Майкл Глэдис', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (111, 'Admin', NOW(), 'Фантастика, Боевики, Приключения', 'Russian', 'Терминатор: Тёмные судьбы', '//avatars.mds.yandex.net/get-kinopoisk-image/1704946/8c034e8e-c5b3-4bd2-bb88-8aa8fd07c20e/300x450', '1025082', '1025082', '2019', '', 'Тим Миллер', 'Линда Хэмилтон, Арнольд Шварценеггер, Маккензи Дэвис, Наталия Рейес, Гэбриел Луна, Диего Бонета, Алисия Боррачеро, Энрике Арсе, Стивен Кри, Ферран Фернандес', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (112, 'Admin', NOW(), 'Фантастика, Боевики, Комедии', 'Russian', 'Дэдпул', '//avatars.mds.yandex.net/get-kinopoisk-image/1629390/f5961569-594e-476d-85ec-2ff29862c95c/300x450', '462360', '462360', '2016', '', 'Тим Миллер', 'Райан Рейнольдс, Морена Баккарин, Эд Скрейн, ТиДжей Миллер, Джина Карано, Брианна Хилдебранд, Стефан Капичич, Лесли Аггамс, Джед Риз, Каран Сони', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (113, 'Admin', NOW(), 'Фантастика, Боевики, Комедии', 'Russian', 'Дэдпул 2', '//avatars.mds.yandex.net/get-kinopoisk-image/1777765/f9da0090-ada3-49fb-b05d-20fbbb80f54b/300x450', '961715', '961715', '2018', '', 'Дэвид Литч', 'Райан Рейнольдс, Джош Бролин, Морена Баккарин, Джулиан Деннисон, Зази Битц, ТиДжей Миллер, Лесли Аггамс, Каран Сони, Брианна Хилдебранд, Джек Кеси', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (114, 'Admin', NOW(), 'Фантастика, Боевики, Комедии', 'Russian', 'Дэдпул и Росомаха', '//avatars.mds.yandex.net/get-kinopoisk-image/10703959/ec1e3f30-0914-4f13-9833-57d679b67aa9/300x450', '1008444', '1008444', '2024', '', 'Шон Леви', 'Райан Рейнольдс, Морена Баккарин, Брианна Хилдебранд, Аарон Стэнфорд, Джош Бролин, Эмма Коррин, Мэттью Макфэдиен, Хью Джекман, Дженнифер Гарнер, Сиори Куцуна', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (115, 'Admin', NOW(), 'Фантастика, Боевики, Триллеры', 'Russian', 'Апгрейд', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/ca1cf536-3adf-40ad-8530-55808ff29e95/300x450', '1009784', '1009784', '2018', '', 'Ли Уоннелл', 'Логан Маршалл-Грин, Мелани Валльехо, Стив Даниелсен, Эбби Краден, Харрисон Гилбертсон, Бенедикт Харди, Ричард Коуторн, Кристофер Кирби, Ричард Анастасиос, Кенни Лоу', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (116, 'Admin', NOW(), 'Фантастика, Боевики, Приключения', 'Russian', 'Алита: Боевой ангел', '//avatars.mds.yandex.net/get-kinopoisk-image/1900788/296962f5-fe56-4036-bdc1-2111c065ff69/300x450', '88173', '88173', '2019', '', 'Роберт Родригес', 'Роза Салазар, Кристоф Вальц, Дженнифер Коннелли, Махершала Али, Эд Скрейн, Джеки Эрл Хейли, Киан Джонсон, Хорхе Лендеборг мл., Лана Кондор, Идара Виктор', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (117, 'Admin', NOW(), 'Фантастика, Боевики', 'Russian', 'Годзилла и Конг: Новая империя', '//avatars.mds.yandex.net/get-kinopoisk-image/10809116/6175f6e6-c38b-4ba1-a30e-0c23a2acfe93/300x450', '4902648', '4902648', '2024', '', 'Адам Вингард', 'Ребекка Холл, Дэн Стивенс, Рэйчел Хаус, Брайан Тайри Генри, Кэйли Хоттл, Мерси Корнуолл, Чэнь Фала, Алекс Фернс, Кэсси Райли, Nicola Crisa', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (118, 'Admin', NOW(), 'Фантастика, Ужасы', 'Russian', 'Прометей', '//avatars.mds.yandex.net/get-kinopoisk-image/1946459/b4410674-5bfd-4a22-8e6f-92ec2395df96/300x450', '467099', '467099', '2012', '', 'Ридли Скотт', 'Нуми Рапас, Майкл Фассбендер, Шарлиз Терон, Идрис Эльба, Гай Пирс, Логан Маршалл-Грин, Шон Харрис, Рейф Сполл, Иман Эллиотт, Бенедикт Вонг', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (119, 'Admin', NOW(), 'Мультфильмы', 'Russian', 'Звериный рейс', '//avatars.mds.yandex.net/get-kinopoisk-image/10900341/abb171a7-f1eb-4eb2-a021-2a77294469fa/300x450', '1173955', '1173955', '2024', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (120, 'Admin', NOW(), 'Боевики, Комедии', 'Russian', 'Большой брат', '//avatars.mds.yandex.net/get-kinopoisk-image/1946459/783e5a38-9f1c-40c7-bad0-2cd898411dbe/360', '1087454', '1087454', '2018', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (121, 'Admin', NOW(), 'Драмы, Комедии', 'Russian', 'Следом за жизнью', '//avatars.mds.yandex.net/get-kinopoisk-image/4303601/61ef6d4b-e70a-43c1-aebf-e3a7d0b53841/300x450', '1172074', '1172074', '2019', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (122, 'Admin', NOW(), 'История, Драмы', 'Russian', 'Агора', '//avatars.mds.yandex.net/get-kinopoisk-image/1629390/6013d48a-a7f9-4d2a-a80f-8cb166d167c8/300x450', '405952', '405952', '2009', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (123, 'Admin', NOW(), 'Драмы, Триллеры', 'Russian', 'Королевская игра', '//avatars.mds.yandex.net/get-kinopoisk-image/4774061/fe5c3620-bb4a-467e-b146-62e59d8ad22c/300x450', '1367826', '1367826', '2021', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (124, 'Admin', NOW(), 'Драмы, Криминал, Триллеры', 'Russian', 'Звук свободы', '//avatars.mds.yandex.net/get-kinopoisk-image/10900341/4fb19ff4-34f2-42de-be25-521b1fcdc2fe/300x450', '1134493', '1134493', '2023', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (125, 'Admin', NOW(), 'Боевики, Драмы, Комедии', 'Russian', 'Бесславные ублюдки', '//avatars.mds.yandex.net/get-kinopoisk-image/1946459/5e6dde98-74a8-4c02-b003-01d48e091025/300x450', '9691', '9691', '2009', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (126, 'Admin', NOW(), 'Драмы, Криминал', 'Russian', 'Острые козырьки', '//avatars.mds.yandex.net/get-kinopoisk-image/1599028/e1ec4209-569e-4745-a324-b180af8097ef/300x450', '716587', '716587', '2013 – 2022', '', '', '', '', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (127, 'Admin', NOW(), 'Боевики, Приключения, Триллеры, Криминал, Детективы', 'Russian', 'Шерлок Холмс', '//avatars.mds.yandex.net/get-kinopoisk-image/1777765/244e2847-f426-4c60-86ba-34cde7db695f/300x450', '420923', '420923', '2009', 'FHD (1080)', 'Гай Ричи', 'Роберт Дауни мл., Джуд Лоу, Рэйчел Макадамс, Марк Стронг, Эдди Марсан, Роберт Мэйллет, Джеральдин Джеймс, Келли Райлли, Уильям Хьюстон, Ханс Мэтисон', 'Величайший в истории сыщик Шерлок Холмс вместе со своим верным соратником Ватсоном вступают в схватку, требующую нешуточной физической и умственной подготовки, ведь их враг представляет угрозу для всего Лондона.', '', '1', '1', '1', '', '0', 0)",
		"INSERT INTO `movies` (`id`,`autor`,`date`,`language`,`title`,`image`,`alt_name`,`search_id`,`year`,`quality`,`director`,`actors`,`short_desc`,`full_desc`,`meta_desc`,`meta_keys`,`allow_comments`,`tags`,`rating`,`views`) VALUES (128, 'Admin', NOW(), 'Триллеры, Ужасы', 'Russian', 'Из глубины', '//avatars.mds.yandex.net/get-kinopoisk-image/4483445/e141c393-257c-445e-9f0c-1076b2cf67cc/300x450', '4745604', '4745604', '2024', 'FHD (1080)', 'Клаудио Фах', '', 'Как выжить на борту затонувшего самолета, окруженного акулами? Фильм-катастрофа для ценителей острых ощущений', '', '1', '1', '1', '', '0', 0)",

		// Добавление дополнительного поля в таблицу `movies_fields`
		"INSERT INTO `movies_fields` (`x_name`, `column_type`, `column_length`) VALUES ('source_url', 'VARCHAR', 255)",

		// Добавление значения дополнительного поля в таблицу `movies_field_values`
		"INSERT INTO `movies_field_values` (`movies_id`, `field_id`, `x_value`) VALUES (1, (SELECT `id` FROM `movies_fields` WHERE `x_name` = 'source_url'), 'https://example.com')",

		// Добавление данных в таблицу `movies_categories`
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (1, 0, 1, 'Russian', 'Фильмы', 'films', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (2, 1, 2, 'Russian', 'Комедии', 'comedie', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (3, 1, 3, 'Russian', 'Драмы', 'drama', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (4, 1, 4, 'Russian', 'Мелодрамы', 'melodrama', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (5, 1, 5, 'Russian', 'Триллеры', 'thriller', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (6, 1, 6, 'Russian', 'Фантастика', 'fantastic', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (7, 1, 7, 'Russian', 'Приключения', 'adventure', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (8, 1, 8, 'Russian', 'Боевики', 'action', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (9, 1, 9, 'Russian', 'Мультфильмы', 'cartoon ', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (10, 1, 10, 'Russian', 'Ужасы', 'horror', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (11, 1, 11, 'Russian', 'История', 'story', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (12, 1, 12, 'Russian', 'Криминал', 'сriminal', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (13, 1, 13, 'Russian', 'Детективы', 'detective', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (14, 1, 14, 'Russian', 'Семейные', 'family', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
            "INSERT INTO `movies_categories` (`id`,`parentid`,`position`,`language`,`name`,`alt_name`,`meta_desc`,`meta_keys`,`short_tpl`,`full_tpl`,`comments`) VALUES (15, 0, 15, 'Russian', 'Сериалы', 'series', '', '', 'short_news.tpl', 'full_news.tpl', 1)",
	];/*

	// Выполнение запросов
	foreach ($addData as $sql) {
		if ($db_connect->query($sql) !== TRUE) {
			echo "Ошибка при добавлении данных: " . $db_connect->error . "\n";
			$successFlag = false;
		}
	}*/

    $categories = [
        ['id' => 1, 'parentid' => 0, 'position' => 1, 'language' => 'russian', 'name' => 'Фильмы', 'alt_name' => 'films', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 2, 'parentid' => 1, 'position' => 2, 'language' => 'russian', 'name' => 'Комедии', 'alt_name' => 'comedie', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 3, 'parentid' => 1, 'position' => 3, 'language' => 'russian', 'name' => 'Драмы', 'alt_name' => 'drama', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 4, 'parentid' => 1, 'position' => 4, 'language' => 'russian', 'name' => 'Мелодрамы', 'alt_name' => 'melodrama', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 5, 'parentid' => 1, 'position' => 5, 'language' => 'russian', 'name' => 'Триллеры', 'alt_name' => 'thriller', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 6, 'parentid' => 1, 'position' => 6, 'language' => 'russian', 'name' => 'Фантастика', 'alt_name' => 'fantastic', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 7, 'parentid' => 1, 'position' => 7, 'language' => 'russian', 'name' => 'Приключения', 'alt_name' => 'adventure', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 8, 'parentid' => 1, 'position' => 8, 'language' => 'russian', 'name' => 'Боевики', 'alt_name' => 'action', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 9, 'parentid' => 1, 'position' => 9, 'language' => 'russian', 'name' => 'Мультфильмы', 'alt_name' => 'cartoon', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 10, 'parentid' => 1, 'position' => 10, 'language' => 'russian', 'name' => 'Ужасы', 'alt_name' => 'horror', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 11, 'parentid' => 1, 'position' => 11, 'language' => 'russian', 'name' => 'История', 'alt_name' => 'story', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 12, 'parentid' => 1, 'position' => 12, 'language' => 'russian', 'name' => 'Криминал', 'alt_name' => 'criminal', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 13, 'parentid' => 1, 'position' => 13, 'language' => 'russian', 'name' => 'Детективы', 'alt_name' => 'detective', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 14, 'parentid' => 1, 'position' => 14, 'language' => 'russian', 'name' => 'Семейные', 'alt_name' => 'family', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
        ['id' => 15, 'parentid' => 0, 'position' => 15, 'language' => 'russian', 'name' => 'Сериалы', 'alt_name' => 'series', 'meta_desc' => '', 'meta_keys' => '', 'short_tpl' => 'short_news.tpl', 'full_tpl' => 'full_news.tpl', 'comments' => 1],
    ];

    // Выполнение вставки
    foreach ($categories as $category) {
        $db_connect->insert('movies_categories', $category);
    }



    $addData = [
        [
            'id' => 1,
            'autor' => 'Admin',
            'date' => date('Y-m-d H:i:s'),
            'language' => 'russian',
            'title' => 'Бесстыжие',
            'image' => '/uploads/images/movies/2024/2/1/image.webp',
            'alt_name' => 'shameless',
            'search_id' => '571335',
            'year' => '2011',
            'quality' => 'FHD (1080)',
            'director' => 'Иэн Б. МакДональд, Марк Майлод, Кристофер Чулак',
            'actors' => 'Уильям Х. Мэйси, Итан Каткоски, Джереми Аллен Уайт, Шанола Хэмптон, Стив Хоуи, Эмма Кинни, Камерон Монахэн, Эмми Россам, Майкл Патрик Макгилл, Ноэль Фишер',
            'short_desc' => 'Краткое описание фильма № 1',
            'full_desc' => 'Американский ремейк британского Сериала...',
            'meta_desc' => '1',
            'meta_keys' => '1',
            'allow_comments' => '1',
            'tags' => 'series, comedy',
            'rating' => '8',
            'views' => 0,
        ],
        [
            'id' => 2,
            'autor' => 'Admin',
            'date' => date('Y-m-d H:i:s'),
            'language' => 'russian',
            'title' => 'Секрет',
            'image' => '/uploads/images/movies/2024/2/2/image.webp',
            'alt_name' => 'secret',
            'search_id' => '1196157',
            'year' => '2018',
            'quality' => 'FHD (1080)',
            'director' => 'Энди Теннант',
            'actors' => 'Кэти Холмс, Джош Лукас, Селия Уэстон, Джерри ОКоннелл, Сара Хоффмайстер, Эйдан Пирс Бреннан, Хлоя Ли, Катрина Бегин, Сидни Теннант, Йоханс Майлс',
            'short_desc' => 'Краткое описание фильма № 2',
            'full_desc' => 'Когда сильный шторм разрушает дом молодой вдовы с тремя детьми, на пороге появляется таинственный незнакомец. Всего за несколько дней загадочный гость объединяет семью и помогает им найти новый смысл в жизни. Он открывает им Секрет, который может изменить все.',
            'meta_desc' => '1',
            'meta_keys' => '1',
            'allow_comments' => '1',
            'tags' => 'comedy, romance',
            'rating' => '7',
            'views' => 0
        ],
        [
            'id' => 3,
            'autor' => 'Admin',
            'date' => date('Y-m-d H:i:s'),
            'language' => 'russian',
            'title' => 'Я-легенда',
            'image' => '/uploads/images/movies/2024/2/3/image.webp',
            'alt_name' => 'movie-3',
            'search_id' => '195524',
            'year' => '2007',
            'quality' => 'FHD (1080)',
            'director' => 'Френсис Лоуренс',
            'actors' => 'Уилл Смит, Алиси Брага, Чарли Тахэн, Салли Ричардсон-Уитфилд, Уиллоу Смит, Даррел Фостер, Эйприл Грэйс, Дэш Майок, Джоанна Нумата, Abbey',
            'short_desc' => 'Краткое описание фильма № 3',
            'full_desc' => 'Неизвестный вирус унёс жизни половины населения земного шара, а остальную половину превратил в вампиров. Единственный уцелевший человек с иммунитетом к заболеванию ночами держит осаду упырей, а днем пытается найти противоядие и докопаться до причин эпидемии.',
            'meta_desc' => '1',
            'meta_keys' => '1',
            'allow_comments' => '1',
            'tags' => 'sci-fi, thriller',
            'rating' => '9',
            'views' => 0
        ],
    ];

    // Вставка данных в таблицу `movies`
    foreach ($addData as $data) {
        $db_connect->insert('movies', $data);
    }

	// Проверяем флаг и выводим сообщение
	if ($successFlag) {
		echo "
			<script>
				alert('Данные модуля фильмов успешно добавлены');
				window.location.href = window.location.href;
			</script>
		";
		exit();
	}