<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Устанавливаем массив для передачи данных в шаблон
    require_once(ENGINE_DIR . '/data/config.php');

    function moviesByCategoryController($category, $lang_code) {
        global $db_connect, $smarty, $config, $lang;

        $categoryData = $db_connect->get("movies_categories", "*", ["alt_name" => $category]);

        if (!$categoryData) {
            // Категория не найдена, отображаем ошибку 404
            header("HTTP/1.0 404 Not Found");
            $smarty->assign('error_message', 'Категория не найдена');
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
            exit;
        }

        $categorySearch = '%' . $categoryData['name'] . '%';

        require_once ENGINE_DIR . '/mods/module_condition_data.php';
        $moviesList = getFilterDataList("movies", $lang_code, null, [
            "n.year"
        ], $categoryData["id"]);
        require_once ENGINE_DIR . '/mods/get_module_categories.php';
    
        // Получаем alt_names для каждой категории
        foreach ($moviesList as &$movie) {
            $movie['category_alt_names'] = getCategoriesAltNames($movie['id'], "movies");
            $categories = getCategoriesList($movie['id'], "movies");
    
            // Декодируем описания новости
            if (!empty($movie['short_desc'])) {
                $movie['short_desc'] = html_entity_decode($movie['short_desc'], ENT_QUOTES, 'UTF-8');
            }
        }
        $categoriesDataList = getModuleCategoriesDataList("movies");

        // Рассчитываем количество страниц для пагинации относительно фильмов с данной категорией
        $currentPage = isset($_GET['page']) ? intval($_GET['page']) : 1;
        $moviesPerPage = $config['modules']['movies']['movies_fromcats_per_page'];
        $totalPages = ceil(count($moviesList) / $moviesPerPage);
    
        // Определяем, с какой новости начинать отображение на текущей странице
        $start = ($currentPage - 1) * $moviesPerPage;
        require_once(ENGINE_DIR . '/mods/pagination.php');
    
        // Передаем данные в Smarty
        $smarty->assign('categoriesDataList', $categoriesDataList);
        $smarty->assign('title', $lang['module_name']['movies'] . ' - ' . $config['title']);
        $smarty->assign('page_name', '
            <li class="breadcrumb-item"><a href="/movies">' . $lang['module_name']['movies'] . '</a></li>
            <li class="breadcrumb-item active">' . $categoryData['name'] . '</li>
        ');
        $smarty->assign('currentPage', $currentPage);
        $smarty->assign('totalPages', $totalPages);
        $smarty->assign('pagination', generatePagination($currentPage, $totalPages));
        $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/modules/movies/' . $config['modules']['movies']['short_tpl'], ['moviesList' => array_slice($moviesList, $start, $moviesPerPage), 'category_alt_names' => $categoryData['alt_name']]));
    
        // Проверяем, выключен ли сайт
        require_once(ENGINE_DIR . '/mods/offline.php');
    }
    $smarty->assign($config);
    