<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Подключаем файл с массивом данных для передачи в шаблон
    require_once(ENGINE_DIR . '/data/config.php');

    function allMoviesController($lang_code) {
        global $db_connect, $smarty, $config, $lang;
    
        // Получаем текущую страницу из URL или устанавливаем ее в 1, если не указана
        $currentPage = isset($_GET['page']) ? intval($_GET['page']) : 1;
    
        // Рассчитываем начальную точку для запроса на основе пагинации
        $start = ($currentPage - 1) * $config['modules']['movies']['movies_per_page'];

        require_once ENGINE_DIR . '/mods/module_condition_data.php';
        $moviesList = getFilterDataList("movies", $lang_code, $start, [
            "n.year"
        ]);

        require_once ENGINE_DIR . '/mods/get_module_categories.php';

        // Для каждого фильма получаем категории и их alt_name
        foreach ($moviesList as $key => &$movie) {
            require_once ENGINE_DIR . '/mods/access_control.php';
            $isPermitted = checkAssess((int)$movie["id"], "movies");
            if (!$isPermitted) {
                unset($moviesList[$key]);
                continue;
            }
            $movie['category_alt_names'] = getCategoriesAltNames($movie['id'], "movies");
            $categories = getCategoriesList($movie['id'], "movies");
    
            // Декодируем описания фильма
            if (!empty($movie['short_desc'])) {
                $movie['short_desc'] = html_entity_decode($movie['short_desc'], ENT_QUOTES, 'UTF-8');
            }
    
            if (!empty($movie['full_desc'])) {
                $movie['full_desc'] = html_entity_decode($movie['full_desc'], ENT_QUOTES, 'UTF-8');
            }
        }
        $categoriesDataList = getModuleCategoriesDataList("movies");


        // Рассчитываем количество страниц для пагинации
        $totalPages = ceil(countMovies($lang_code) / $config['modules']['movies']['movies_per_page']);
        require_once(ENGINE_DIR . '/mods/pagination.php');
    
        // Передаем данные в Smarty
        $smarty->assign('categoriesDataList', $categoriesDataList);
        $smarty->assign('title', $lang['module_name']['movies'] . ' - ' . $config['title']);

        require_once(ENGINE_DIR . '/mods/binding_control.php');
        generateBindings("movies", '<li class="breadcrumb-item active">'. $lang['module_name']['movies'] . '</li>');

        $smarty->assign('currentPage', $currentPage);
        $smarty->assign('totalPages', $totalPages);
        $smarty->assign('pagination', generatePagination($currentPage, $totalPages));
        $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/modules/movies/' . $config['modules']['movies']['short_tpl'], ['moviesList' => $moviesList]));
    
        // Проверяем, выключен ли сайт
        require_once(ENGINE_DIR . '/mods/offline.php');
    }
    
    // Функция для подсчета общего количества фильмов с фильтрацией по языку
    function countMovies($lang_code) {
        global $db_connect;

        $count = $db_connect->count('movies', [
            'language' => $lang_code
        ]);

        return $count;
    }
    
    $smarty->assign($config);