<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Устанавливаем массив для передачи данных в шаблон
    require_once(ENGINE_DIR . '/data/config.php');

    // Устанавливаем функционал комментариев
    require_once(ENGINE_DIR . '/mods/comments.php');
    require_once(ENGINE_DIR . '/mods/database_helper.php');
    function newsController($moduletype, $lang_code) {
        global $smarty, $config, $lang, $db_connect;

        require_once ENGINE_DIR.'/mods/banned_words_detector.php';

        if (!checkIsAccessComment()) {
            $smarty->assign("commentingBlocked", true);
        }

        // Получаем данные из базы данных с помощью Medoo
        $moduletype = $db_connect->get('news', '*', [
            'alt_name' => $moduletype,
            'language' => $lang_code
        ]);

        if (!$moduletype) {
            // Если новость не найдена, показываем ошибку
            $smarty->assign('error_message', 'Новость не найдена');
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
            return;
        }

        // Получаем значения динамических полей для новости
        require_once(ENGINE_DIR . '/mods/extra_fields.php');
        $newsFields = getDynamicFieldValues($db_connect, $moduletype['id'], 'news');

        $smarty->assign('x_value', $newsFields['x_value'] ?? "");
        $moduletype['short_desc'] = html_entity_decode($moduletype['short_desc'], ENT_QUOTES, 'UTF-8');
        $moduletype['full_desc'] = html_entity_decode($moduletype['full_desc'], ENT_QUOTES, 'UTF-8');

        // Получаем и строим дерево комментариев
        $comments = fetch_comments($moduletype['id'], 'news');
        $moduletype_comments = build_comment_tree($comments);

        $moduleName = "news";

        require_once ENGINE_DIR . '/mods/get_module_categories.php';
        $moduletype['category_alt_names'] = getCategoriesAltNames($moduletype['id'], $moduleName);
        $categories = getCategoriesList($moduletype['id'], $moduleName);

        require_once(ENGINE_DIR . '/mods/widget-select.php');
        $smarty->assign('dynamicName', $moduletype["title"]);

        $smarty->assign('title', $moduletype['title']  . ' - ' . $lang['module_name']['news'] . ' - ' . $config['title']);

        require_once(ENGINE_DIR . '/mods/binding_control.php');
        generateBindings($moduleName, '
            <li class="breadcrumb-item"><a href="/news">' . $lang['module_name']['news'] . '</a></li>
            <li class="breadcrumb-item active">' . $moduletype['title'] . '</li>
        ');

        $smarty->assign('user_id', $_SESSION['user_email'] ?? null);
        $smarty->assign('category_alt_names', $moduletype['category_alt_names']);
        $smarty->assign('categories', $categories);
        $smarty->assign('keywords', $moduletype['meta_keys']);
        $smarty->assign('description', $moduletype['meta_desc']);
        $smarty->assign('news', $moduletype);
        $smarty->assign('comments', $moduletype_comments);
        $smarty->assign('entity', ['id' => $moduletype['id']]);
        $smarty->assign('entity_type', 'news');

        $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/modules/news/' . $config['modules']['news']['full_tpl'], ['news' => $moduletype]));

        require_once(ENGINE_DIR . '/mods/offline.php');
    }

// Устанавливаем счетчик просмотров
    $smarty->assign($config);