<?php


    /*
            *****************************************************************************
            * MEGA Digital Space - by MEGA Digital Studio                               *
            * ------------------------------------------------------------------------- *
            * CMS Website:  https://megadigital.space                                   *
            * License:  https://megadigital.space/license                               *
            * Owner:  Giorgi Basharuli                                                  *
            * Contact:  online@megadigital.studio                                       *
            * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
            * Website:  https://megadigital.studio                                      *
            * ------------------------------------------------------------------------- *
            * Description: This file is a part of the MEGA Digital Space CMS system.    *
            * Unauthorized distribution, modification, or commercial use is strictly -  *
            * prohibited without prior written permission.                              *
            * ------------------------------------------------------------------------- *
            * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
            * All rights reserved.                                                      *
            *****************************************************************************
        */

    function addObjectProductController()
    {
        global $smarty, $config, $db_connect, $lang, $user_authenticated;

        $user = $db_connect->get("users", "*", ["email" => $_SESSION["user_email"] ?? null]);

        if (!$user) {
            // Пользователь не найден
            $smarty->assign('error_message', 'У вас нет доступа к этой странице');
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
        } else {

            $module_entity = "products";
            require_once(SYSTEM_DIR . '/plugins/reserved_urls.php');

            $categories = [];
            $result = $db_connect->select("products_categories", "*") ?? [];
            if (!empty($result["id"])) {
                $categories[] = $result;
            } else {
                foreach ($result as $row) {
                    $categories[] = $row;
                }
            }

            $error_message = '';

            // Обработка формы добавления файла
            if (isset($_POST['addproduct'])) {
                $folder = $_POST['folder'] ?? '';
                $p_id = (int)$db_connect->max("products", "id") + 1;

                // Подготовка запроса на добавление в таблицу products_field_values
                $x_values = isset($_POST['x_value']) ? implode(', ', $_POST['x_value']) : '';
                $field_ids = $_POST['field_ids'] ?? [];
                $products_id = $p_id;

                // Проверка загруженного изображения (не в редакторе)
                require_once(ENGINE_DIR . '/mods/check_upload_image.php');

                // Получаем данные из формы
                $autor = isset($_POST['autor']) ? strip_tags(trim($_POST['autor'])) : '';
                $date = isset($_POST['date']) && !empty($_POST['date']) ? strip_tags(trim($_POST['date'])) : date($config['date_format']);
                $category = isset($_POST['category']) ? (is_array($_POST['category']) ? implode(', ', $_POST['category']) : $_POST['category']) : '';
                $language = isset($_POST['language']) ? (is_array($_POST['language']) ? implode(', ', $_POST['language']) : $_POST['language']) : '';
                $title = strip_tags(trim($_POST['title']));
                $alt_name = strip_tags(trim($_POST['alt_name']));
                $short_desc = htmlspecialchars($_POST['short_desc'], ENT_QUOTES);
                $full_desc = htmlspecialchars($_POST['full_desc'], ENT_QUOTES);
                $meta_keys = isset($_POST['meta_keys']) ? strip_tags(trim($_POST['meta_keys'])) : '';
                $meta_desc = isset($_POST['meta_desc']) ? strip_tags(trim($_POST['meta_desc'])) : '';
                $price = isset($_POST['price']) ? (float)strip_tags(trim($_POST['price'])) : 0.0;
                $stock_quantity = isset($_POST['stock_quantity']) ? (int)strip_tags(trim($_POST['stock_quantity'])) : 0;
                $measure_unit = isset($_POST['measure_unit']) && is_array($_POST['measure_unit']) ? implode(', ', $_POST['measure_unit']) : '';
                $brand = strip_tags(trim($_POST['brand']));
                $model = strip_tags(trim($_POST['model']));
                $sku = strip_tags(trim($_POST['sku']));
                $mass = strip_tags(trim($_POST['mass']));
                $dimensions = strip_tags(trim($_POST['dimensions']));
                $color = isset($_POST['color']) && is_array($_POST['color']) ? implode(', ', $_POST['color']) : '';
                $material = strip_tags(trim($_POST['material']));
                $warranty = isset($_POST['warranty']) && is_array($_POST['warranty']) ? implode(', ', $_POST['warranty']) : '';
                $discount = isset($_POST['discount']) ? (float)strip_tags(trim($_POST['discount'])) : 0.0;
                $promotion = isset($_POST['promotion']) && is_array($_POST['promotion']) ? implode(', ', $_POST['promotion']) : '';
                $min_order = strip_tags(trim($_POST['min_order']));
                $views = isset($_POST['views']) ? intval($_POST['views']) : 0;

                // Проверяем, было ли загружено изображение
                if (empty($image)) {$error_message .= "Изображение не загружено.<br>";}
                // Проверяем, содержит ли URL запрещённые символы
                $forbidden_char_found = containsForbiddenChars($alt_name, $reserved_urls['forbidden_chars']); // Проверяем без преобразования в нижний регистр
                if ($forbidden_char_found) {
                    // Если найден запрещённый символ, создаём сообщение об ошибке
                    $error_message = "Ошибка: URL содержит запрещённый символ: '{$forbidden_char_found}'.";
                    $smarty->assign('error_message', $error_message);
                }
                // Преобразуем URL в нижний регистр для проверки на зарезервированные значения
                elseif (array_key_exists(strtolower($alt_name), $reserved_urls)) {
                    // Если URL зарезервирован, создаём сообщение об ошибке
                    $error_message = "Ошибка: " . $reserved_urls[strtolower($alt_name)];
                    $smarty->assign('error_message', $error_message);
                } elseif (empty($error_message)) {

                    $result = $db_connect->insert("products", [
                        "autor" => $autor,
                        "date" => $date,
                        "language" => $language,
                        "title" => $title,
                        "short_desc" => $short_desc,
                        "full_desc" => $full_desc,
                        "meta_desc" => $meta_desc,
                        "meta_keys" => $meta_keys,
                        "price" => $price,
                        "stock_quantity" => $stock_quantity,
                        "measure_unit" => $measure_unit,
                        "brand" => $brand,
                        "model" => $model,
                        "sku" => $sku,
                        "mass" => $mass,
                        "dimensions" => $dimensions,
                        "color" => $color,
                        "material" => $material,
                        "warranty" => $warranty,
                        "discount" => $discount,
                        "promotion" => $promotion,
                        "min_order" => $min_order,
                        "views" => $views,
                        "image" => $image,
                        "alt_name" => $alt_name,
                    ]);

                    $products_id = $db_connect->id();

                    if (!empty($_POST["category"])) {
                        foreach ($_POST["category"] as $categoryId) {
                            $db_connect->insert("products_cat_relations", [
                                "products_id" => (int)$products_id,
                                "category_id" => (int)$categoryId,
                            ]);
                        }
                    }

                    require_once ENGINE_DIR . '/mods/access_control.php';
                    saveAccessSettings((int)$products_id, "products", $_POST["exclude_locations"] ?? [], $_POST["include_locations"] ?? [], $_POST["groups"]);

                    if (!empty($field_ids)) {
                        foreach ($field_ids as $field_id) {
                            if (!empty($_POST['x_value'][$field_id])) {
                                $insertField = $db_connect->insert("products_field_values", [
                                    "products_id" => $products_id,
                                    "field_id" => $field_id,
                                    "x_value" => $_POST['x_value'][$field_id]
                                ]);
                            }
                        }
                    }
                    // Проверяем результат выполнения запроса
                    if ($result) {
                        // Перенаправление на ту же страницу после добавления
                        header("Location: /admin?action=products/list");
                        exit();
                    } else {
                        $error_message .= "Ошибка при добавлении файла: " . $db_connect->error . "<br>";
                    }
                }
            }


            $lastRow = $db_connect->get("products", ['id'], [
                "ORDER" => ["id" => "DESC"] // Сортировка по убыванию id
            ]);

            require_once(SYSTEM_DIR . '/plugins/extra_fields.php');
            $smarty->assign("selectedModuleAdd", $module_entity);

            $smarty->assign('title', 'Add products - MDS');
            $smarty->assign('page_name', '
                                    <li class="breadcrumb-item active"><a href="/products">Products</a></li>
                                ');
            $smarty->assign('add_page', 'add_page');
            $smarty->assign('page_id', $lastRow["id"] ?? 0 + 1);
            $smarty->assign('max_id', 0 + 1);
            /*        $smarty->assign('theme', SYSTEM_DIR);*/
            $smarty->assign('config', $config);
            $smarty->assign('categories', $categories);
            /*        $smarty->assign('error_message', $error_message);*/
            $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/modules/products/add.tpl'));
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/main.tpl');

            exit;

        }
    }