<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */
    
    // Устанавливаем массив для передачи данных в шаблон
    require_once(ENGINE_DIR . '/data/config.php');
    require_once(ENGINE_DIR . '/mods/smarty_temp_tpl.php');
    require_once(ENGINE_DIR . '/mods/locationV2.php');

    function pagesController($moduletype, $lang_code) {
        global $db_connect, $smarty, $config, $lang, $ps_config, $user_authenticated;
        // Устанавливаем язык из сессии или используем язык по умолчанию

        blockUrlForUSA();

        // Загружаем языковой файл
        $lang = load_language($lang_code);
        // Выполняем запрос к БД с учётом языка
        $result = $db_connect->select('static_pages', '*', [
            'alt_name' => $moduletype,
            'language' => $lang_code
        ]);

// Проверка, есть ли результат
        if (!empty($result)) {
            $moduletype = $result[0]; // Получаем первый результат (если их несколько)
            // Теперь можно работать с $moduletype
          //  echo $moduletype['column_name']; // Например, вывести столбец column_name
        } else {
            $moduletype = null;
            //echo "Нет данных для заданных параметров.";
        }

        if (!$moduletype) {
            // Страница не существует
            $smarty->assign('error_message', 'Страница не существует');
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
        } else {
            $moduletype['full_desc'] = html_entity_decode($moduletype['full_desc'] ?? "", ENT_QUOTES, 'UTF-8');

            if (isset($_GET["status"])) {
                $smarty->assign("status", $_GET["status"]);
            } else {
                $smarty->assign("status", "");
            }
            $smarty->assign("currency", getCurrentCurrency());
            $smarty->assign("payment_configs", $ps_config);
            $smarty->assign("lang", $lang);
            $moduletype['full_desc'] = renderTempTpl($smarty, $moduletype['full_desc']);

/*
            $moduleName = $moduletype;
            $moduletype["id"] = $result[0]["id"];
            require_once(ENGINE_DIR . '/mods/widget-select.php');

            if (!empty($widget)) {
                $smarty->assign('dynamicName', "pages");
                $smarty->assign('price', $widget["price"]);
                $smarty->assign('widgetId', $widget["id"]);

                $html = $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/payments-widgets/' . $widget["template_name"] . ".tpl");
                $moduletype['full_desc'] = preg_replace('/\{\s*payment-widget\s*\}/', $html, $moduletype['full_desc']);
            } else {
                $moduletype['full_desc'] = preg_replace('/\{\s*payment-widget\s*\}/', "", $moduletype['full_desc']);
            }
*/


            require_once ENGINE_DIR."/mods/breadcrumbs.php";
            $page_name = generateBreadcrumbs($db_connect, $lang);
            $smarty->assign("title", generatePageTitle($db_connect, $lang));
            $smarty->assign('page_name', $page_name);

         /*   // Устанавливаем массив переменных в Smarty
            $smarty->assign('title', $moduletype['title'] . ' - Skills Engine');
            $smarty->assign('page_name', '
                <li class="breadcrumb-item active">' . $moduletype['title'] . '</li>
            ');*/
            // Передаем данные в Smarty
            $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/pages.tpl', ['page' => $moduletype]));

            // Проверяем, выключен ли сайт
            require_once(ENGINE_DIR . '/mods/offline.php');
        }
        // Устанавливаем счетчик просмотров
        $sqltablename = 'static_pages';
        require_once(ENGINE_DIR . '/mods/views.php');
    }

    function blockUrlForUSA() {
        global $smarty, $config;

        $geoData = getRequestUserFullInfo();

        if (in_array($geoData["country"], $config["excluded_urls"]["spaces"])) {
            foreach ($config["excluded_urls"]["static_pages"] as $staticPage) {
                if ($_SERVER['REQUEST_URI'] === $staticPage) {
                    $smarty->assign('error_message', 'Эта страница недоступна в вашей стране');
                    $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
                    exit();
                }
            }
        }
    }

    $smarty->assign($config);