<!doctype html>
<html lang="en" class="h-100 p-0 m-0">
<head>
    <title>Registration form - {$title}</title>
    <meta charset="{$charset}">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="generator" content="{$generator}">
    <meta name="keywords" content="{$keywords}">
    <meta name="description" content="{$description}">
    <link rel="apple-touch-icon" sizes="180x180" href="../..{$stheme}/images/favicons/apple-touch-icon-180x180.png">
    <link rel="icon" href="../..{$stheme}/images/favicons/favicon-32x32.png" sizes="32x32">
    <link rel="stylesheet" href="{$stheme}/css/bootstrap.css">
    <link rel="stylesheet" href="{$stheme}/css/style.css">
    <link rel="stylesheet" href="{$stheme}/css/engine.css">
    <link rel="stylesheet" href="{$stheme}/css/font-awesome.css">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
</head>
<body data-bvite="theme-CeruleanBlue" class="layout-border svgstroke-a layout-default auth overflow-hidden h-100 p-0 m-0">
    <main class="container-fluid px-0 overflow-hidden h-100">
        <aside class="px-xl-5 px-4 auth-aside overflow-hidden h-100" data-bs-theme="none">
            <div class="row">
                <div class="col-12">
                    <img class="img-responsive" src="{$stheme}/images/registration.png" alt="">
                </div>
            </div>
        </aside>

        <div class="px-xl-4 px-3 py-xl-4 py-3 auth-body registration-body overflow-hidden h-100 d-flex flex-column h-100">
            <div class="d-flex justify-content-between w-100">
                <h4 class="registration-form-title"><strong>Registration form</strong></h4>
                <li class="nav-item dropdown custom-dropdown d-md-inline-flex d-flex">
                <a class="navbar-nav-link rounded " href="#" data-bs-toggle="dropdown" aria-expanded="false">
                    <svg width="20" height="20" fill="currentColor" viewBox="0 0 24 24" class="theme-icon-active opacity-50"><use href="#sun-fill"></use></svg>
                </a>
                <ul class="dropdown-menu dropdown-menu-end p-xl-2 shadow rounded-2" aria-labelledby="bd-theme" style="width: 170px;">
                    <a class="themelink dropdown-item rounded-1" href="#" data-bs-theme-value="light">
                    <svg class="me-2 opacity-50 theme-icon" fill="currentColor" width="16" height="16"><use href="#sun-fill"></use></svg> Light
                    </a>
                    <a class="themelink dropdown-item rounded-1" href="#" data-bs-theme-value="dark">
                    <svg class="me-2 opacity-50 theme-icon" fill="currentColor" width="16" height="16"><use href="#moon-stars-fill"></use></svg> Dark
                    </a>
                    <a class="themelink dropdown-item rounded-1" href="#" data-bs-theme-value="auto">
                    <svg class="me-2 opacity-50 theme-icon" fill="currentColor" width="16" height="16"><use href="#circle-half"></use></svg> Auto (AM|PM)
                    </a>
                </ul>

                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16" style="display: none;">
                    <symbol id="sun-fill" viewBox="0 0 16 16">
                    <path d="M12 8a4 4 0 1 1-8 0 4 4 0 0 1 8 0zM8 0a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 0zm0 13a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 13zm8-5a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2a.5.5 0 0 1 .5.5zM3 8a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2A.5.5 0 0 1 3 8zm10.657-5.657a.5.5 0 0 1 0 .707l-1.414 1.415a.5.5 0 1 1-.707-.708l1.414-1.414a.5.5 0 0 1 .707 0zm-9.193 9.193a.5.5 0 0 1 0 .707L3.05 13.657a.5.5 0 0 1-.707-.707l1.414-1.414a.5.5 0 0 1 .707 0zm9.193 2.121a.5.5 0 0 1-.707 0l-1.414-1.414a.5.5 0 0 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .707zM4.464 4.465a.5.5 0 0 1-.707 0L2.343 3.05a.5.5 0 1 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .708z"/>
                    </symbol>
                    <symbol id="moon-stars-fill" viewBox="0 0 16 16">
                    <path d="M6 .278a.768.768 0 0 1 .08.858 7.208 7.208 0 0 0-.878 3.46c0 4.021 3.278 7.277 7.318 7.277.527 0 1.04-.055 1.533-.16a.787.787 0 0 1 .81.316.733.733 0 0 1-.031.893A8.349 8.349 0 0 1 8.344 16C3.734 16 0 12.286 0 7.71 0 4.266 2.114 1.312 5.124.06A.752.752 0 0 1 6 .278z"/>
                    <path d="M10.794 3.148a.217.217 0 0 1 .412 0l.387 1.162c.173.518.579.924 1.097 1.097l1.162.387a.217.217 0 0 1 0 .412l-1.162.387a1.734 1.734 0 0 0-1.097 1.097l-.387 1.162a.217.217 0 0 1-.412 0l-.387-1.162A1.734 1.734 0 0 0 9.31 6.593l-1.162-.387a.217.217 0 0 1 0-.412l1.162-.387a1.734 1.734 0 0 0 1.097-1.097l.387-1.162zM13.863.099a.145.145 0 0 1 .274 0l.258.774c.115.346.386.617.732.732l.774.258a.145.145 0 0 1 0 .274l-.774.258a1.156 1.156 0 0 0-.732.732l-.258.774a.145.145 0 0 1-.274 0l-.258-.774a1.156 1.156 0 0 0-.732-.732l-.774-.258a.145.145 0 0 1 0-.274l.774-.258c.346-.115.617-.386.732-.732L13.863.1z"/>
                    </symbol>
                    <symbol id="circle-half" viewBox="0 0 16 16">
                    <path d="M8 15A7 7 0 1 0 8 1v14zm0 1A8 8 0 1 1 8 0a8 8 0 0 1 0 16z"/>
                    </symbol>
                </svg>
                </li>
            </div>
            
            <form id="registration-form" method="POST" class="needs-validation new-form-wrapper pe-el-4 pe-3" novalidate enctype="multipart/form-data">
                
                <div class="mb-3">
                    <label for="roleSelector" class="form-label">Выберите Роль:</label>
                    <select id="roleSelector" class="form-select">
                        <option value="Company">Company</option>
                        <option value="Creator">Creator</option>
                        <option value="User" selected>User</option>
                    </select>
                </div>

                <div class="mb-3" id="companyTypeWrapper" style="display: none;">
                    <label for="company_type">Company Type:</label>
                    <select name="company_type" id="company_type" class="form-control">
                        <option value="single" selected>Single Location</option>
                        <option value="business">Business Network</option>
                    </select>
                </div>

                {if $error_message}
                    <div class="alert alert-danger" role="alert">{$error_message}</div>
                {/if}
                {if $success_message}
                    <div class="alert alert-success" role="alert">{$success_message}</div>
                {/if}
                <div class="tab-content" id="pills-tabContent">
                    {foreach ['Company', 'SelfEmployer', 'Creator', 'User'] as $role}
                        <div class="tab-pane fade {if $role == "User"}show active{/if}" id="{$role}" role="tabpanel">             
                            {if $role == "User"}
                                {include file="templates/registration/User.tpl"}
                            {/if}
                            {if $role == "Creator"}
                                {include file="templates/registration/Creator.tpl"}
                            {/if}
                            {if $role == "SelfEmployer"}
                                {include file="templates/registration/SelfEmployer.tpl"}
                            {/if}
                            {if $role == "Company"}
                                <div id="company">
                                    <div id="company_single">
                                        {include file="templates/registration/SingleLocation.tpl"}

                                    </div>
                                    <div id="company_business" style="display: none;">
                                        {include file="templates/registration/BusinessNetwork.tpl"}
                                    </div>
                                </div>
                            {/if}
                        </div>
                    {/foreach}
                    {if $config.captcha_settings.enabled_captcha === "google"}
                        <div class="col-md-12 mb-3">
                            <div class="g-recaptcha" data-sitekey="{$config.captcha_settings.api_site_key}"></div>
                            <div class="captcha-invalid-feedback">Please complete the captcha.</div>
                        </div>
                    {else}
                        <div class="col-md-12 mb-3">
                            <label for="security_answer">Question: {$security_question_text}</label>
                            <input type="text" name="security_answer" class="form-control" placeholder="Only digits" required>
                            <input type="hidden" name="security_question_id" value="{$security_question_id}">
                            <div class="invalid-feedback">Please answer the security question.</div>
                        </div>
                    {/if}
                </div>

                <!-- Разделитель -->
                <hr>

                <!-- Альтернативный вход -->
                <div class="login-from-social text-center mt-2">
                    <h6 class="mb-2">Login with</h6>
                    <div class="d-flex justify-content-center gap-2">
                        <a href="{$google_login_url}">
                            <img height="40" src="/templates/universal/assets/images/gauth.png" alt="Войти через Google">
                        </a>
                        <a href="{$facebook_login_url}">
                            <img height="45" src="/templates/universal/assets/images/fauth.png" alt="Войти через Facebook">
                        </a>
                    </div>
                </div>


                <button type="submit" name="register_submit" class="btn btn-primary w-100 register-btn">Register</button>
            </form>
            <div class="align-items-center text-muted mt-2 d-flex">
                <span>© 2025</span>
                <a href="https://megadigital.space/" target="_blank" class="ms-1">Mega Digital Space</a>
                <span class="ms-1 d-none d-sm-flex">, All Rights Reserved.</span>
            </div>
        </div>
    </main>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="{$stheme}/js/bootstrap.bundle.min.js"></script>
    <script src="{$theme}/assets/js/registration_page.js"></script>
    <script src="{$stheme}/js/theme.js"></script>
    <script src="{$stheme}/js/main.js"></script>
</body>
</html>