<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

	// Устанавливаем массив для передачи данных в шаблон
	require_once(ENGINE_DIR . '/data/config.php');

    function universalController() {
        global $smarty, $config, $db_connect, $lang_code, $adsAvailable, $filesAvailable, $eventsAvailable, $moviesAvailable, $newsAvailable, $productsAvailable, $adsUsed, $eventsUsed, $filesUsed, $moviesUsed, $newsUsed, $productsUsed;
        // Подгатавливаем отображение для определённой страницы "/modules"
        $current_url = $_SERVER['REQUEST_URI'];
        // Проверяем, содержит ли URL путь "/modules"
        if (strpos($current_url, '/modules') !== false) {
            // Инициализация массива данных о версиях и дате добавления файлов ads, events, files, movies, news, products
            $data = [];
            if($filesAvailable && $filesUsed){
                $result = $db_connect->select('files', ['alt_name', 'version', 'date'], [
                    'alt_name' => ['ads', 'events', 'files', 'movies', 'news', 'products']
                ]);

                $data = [];
                if ($result) {
                    foreach ($result as $row) {
                        $data[$row['alt_name']] = [
                            'version' => $row['version'],
                            'date' => $row['date']
                        ];
                    }
                }

                // Передаём данные для отображения версии и даты модуля в раздел модули
                $smarty->assign('adsVersion', $data['ads']['version'] ?? "");
                $smarty->assign('adsDate', $data['ads']['date'] ?? "");
                // $smarty->assign('auctionsVersion', $data['auctions']['version']);
                // $smarty->assign('auctionsDate', $data['auctions']['date']);
                $smarty->assign('eventsVersion', $data['events']['version'] ?? "");
                $smarty->assign('eventsDate', $data['events']['date'] ?? "");
                $smarty->assign('filesVersion', $data['files']['version'] ?? "");
                $smarty->assign('filesDate', $data['files']['date'] ?? "");
                // $smarty->assign('forumVersion', $data['forum']['version']);
                // $smarty->assign('forumDate', $data['forum']['date']);
                // $smarty->assign('galleryVersion', $data['gallery']['version']);
                // $smarty->assign('galleryDate', $data['gallery']['date']);
                $smarty->assign('moviesVersion', $data['movies']['version']?? "");
                $smarty->assign('moviesDate', $data['movies']['date'] ?? "");
                $smarty->assign('newsVersion', $data['news']['version'] ?? "");
                $smarty->assign('newsDate', $data['news']['date'] ?? "");
                // $smarty->assign('onlinecoursesVersion', $data['onlinecourses']['version']);
                // $smarty->assign('onlinecoursesDate', $data['onlinecourses']['date']);
                $smarty->assign('productsVersion', $data['products']['version'] ?? "");
                $smarty->assign('productsDate', $data['products']['date'] ?? "");
                // $smarty->assign('realestateVersion', $data['realestate']['version']);
                // $smarty->assign('realestateDate', $data['realestate']['date']);
            }
        }

        // Получаем категории объявлений
        if($adsAvailable && $adsUsed){
            // Получение 10 последних добавленных объявлений
            if($config['modules']['ads']['latest_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/ads/widgets/latest-entries.php');
            }
            // Получение 10 популярных объявлений по рейтингу
            if($config['modules']['ads']['popular_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/ads/widgets/popular-entries.php');
            }
            // Получение 10 самых просматриваемых объявлений
            if($config['modules']['ads']['most_viewed_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/ads/widgets/most-viewed-entries.php');
            }
            // Получение 10 похожих объявлений
            if($config['modules']['ads']['similar_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/ads/widgets/similar-entries.php');
            }
            // Получаем категории объявлений
	        require_once(ENGINE_DIR . '/controllers/modules/ads/widgets/categories.php');
        }

        // Получаем категории файлов
        if($filesAvailable && $filesUsed){
            // Получение 10 последних добавленных файлов
            if($config['modules']['files']['latest_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/files/widgets/latest-entries.php');
            }
            // Получение 10 популярных файлов по рейтингу
            if($config['modules']['files']['popular_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/files/widgets/popular-entries.php');
            }
            // Получение 10 самых просматриваемых файлов
            if($config['modules']['files']['most_viewed_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/files/widgets/most-viewed-entries.php');
            }
            // Получение 10 похожих файлов
            if($config['modules']['files']['similar_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/files/widgets/similar-entries.php');
            }
            // Получаем категории файлов
	        require_once(ENGINE_DIR . '/controllers/modules/files/widgets/categories.php');
        }

        // Получаем категории мероприятий
        if($eventsAvailable && $eventsUsed){
            // Получение 10 последних добавленных мероприятий
            if($config['modules']['events']['latest_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/events/widgets/latest-entries.php');
            }
            // Получение 10 популярных мероприятий по рейтингу
            if($config['modules']['events']['popular_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/events/widgets/popular-entries.php');
            }
            // Получение 10 самых просматриваемых мероприятий
            if($config['modules']['events']['most_viewed_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/events/widgets/most-viewed-entries.php');
            }
            // Получение 10 похожих мероприятий
            if($config['modules']['events']['similar_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/events/widgets/similar-entries.php');
            }
            // Получаем категории мероприятий
	        require_once(ENGINE_DIR . '/controllers/modules/events/widgets/categories.php');
        }

        // Получаем категории фильмов
        if($moviesAvailable && $moviesUsed){
            // Получение 10 последних добавленных фильмов
            if($config['modules']['movies']['latest_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/movies/widgets/latest-entries.php');
            }
            // Получение 10 популярных фильмов по рейтингу
            if($config['modules']['movies']['popular_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/movies/widgets/popular-entries.php');
            }
            // Получение 10 самых просматриваемых фильмов
            if($config['modules']['movies']['most_viewed_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/movies/widgets/most-viewed-entries.php');
            }
            // Получение 10 похожих фильмов
            if($config['modules']['movies']['similar_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/movies/widgets/similar-entries.php');
            }
            // Получаем категории фильмов
	        require_once(ENGINE_DIR . '/controllers/modules/movies/widgets/categories.php');
        }

        // Получаем категории и 10 последних новостей
        if($newsAvailable && $newsUsed){
            // Получение 10 последних добавленных новостей
            if($config['modules']['news']['latest_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/news/widgets/latest-entries.php');
            }
            // Получение 10 популярных новостей по рейтингу
            if($config['modules']['news']['popular_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/news/widgets/popular-entries.php');
            }
            // Получение 10 самых просматриваемых новостей
            if($config['modules']['news']['most_viewed_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/news/widgets/most-viewed-entries.php');
            }
            // Получение 10 похожих новостей
            if($config['modules']['news']['similar_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/news/widgets/similar-entries.php');
            }
            // Получаем категории новостей
	        require_once(ENGINE_DIR . '/controllers/modules/news/widgets/categories.php');
        }

        // Получаем категории товаров и количество товаров в корзине
        if($productsAvailable && $productsUsed){
            // Получение 10 последних добавленных товаров
            if($config['modules']['products']['latest_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/products/widgets/latest-entries.php');
            }
            // Получение 10 популярных товаров по рейтингу
            if($config['modules']['products']['popular_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/products/widgets/popular-entries.php');
            }
            // Получение 10 самых просматриваемых товаров
            if($config['modules']['products']['most_viewed_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/products/widgets/most-viewed-entries.php');
            }
            // Получение 10 похожих товаров
            if($config['modules']['products']['similar_entries']){
                require_once(ENGINE_DIR . '/controllers/modules/products/widgets/similar-entries.php');
            }
            // Получаем категории товаров
	        require_once(ENGINE_DIR . '/controllers/modules/products/widgets/categories.php');
        }

        // Передаем данные в Smarty
        $smarty->assign('engine', $config['engine']);
        $smarty->assign('stheme', $config['stheme']);

        // Проверка нажатия кнопки с name submit_participants
        if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit_participants'])) {
            // Устанавливаем форму обратной связи в глобальное пространство
            require_once(ENGINE_DIR . '/mods/event_participants.php');
        }

        // Проверка нажатия кнопки с name submit_participants
        if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit_lot_participants'])) {
            // Устанавливаем форму обратной связи в глобальное пространство
            require_once(ENGINE_DIR . '/mods/lot_participants.php');
        }

        // Проверка нажатия кнопки с name submit_feedback
        if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit_feedback'])) {
            // Устанавливаем форму обратной связи в глобальное пространство
            require_once(ENGINE_DIR . '/mods/submit_feedback.php');
        }
    }

    universalController();
    $smarty->assign('config', $config);
    $smarty->assign('mds_version', $config['mds_version']);
    
    // Передача текущего адреса в шаблон
    $currentUrl = $_SERVER['REQUEST_URI'];
    $smarty->assign('currentUrl', $currentUrl);

    // Передача статусов информеров модулей в Smarty
    $modules = ['ads', 'events', 'files', 'movies', 'news', 'products'];
    $statuses = ['latest_entries', 'popular_entries', 'most_viewed_entries', 'similar_entries'];
    foreach ($modules as $module) {
        foreach ($statuses as $status) {
            $smarty->assign("{$module}_{$status}", $config['modules'][$module][$status]);
        }
    }