<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require_once(ENGINE_DIR . '/data/config.php');


    function userProfileController() {

        global $db_connect, $smarty, $config;
        $user_id = isset($_GET['user_id']) ? (int)$_GET['user_id'] : null;


        if ($user_id !== null) {
            // Получаем пользователя по ID
            $user = $db_connect->get('users', '*', ['id' => $user_id]);

            if ($user) {
                $smarty->assign('title', $user['name'] . ' - Профиль пользователя');
                $smarty->assign('page_name', '<li class="breadcrumb-item active">' . $user['name'] . '</li>');
                $smarty->assign('userData', $user);

                $smarty->assign('content', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/user-profile.tpl'));
                $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/main.tpl');
                // Проверка на отключение сайта
                require_once(ENGINE_DIR . '/mods/offline.php');
            } else {
                // Пользователь не найден
                $smarty->assign('error_message', 'Пользователь не найден');
                $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
            }
        } else {
            // Пользователь не найден
            $smarty->assign('error_message', 'Пользователь не найден');
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/error.tpl');
        }
    }

    $smarty->assign($config);