<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

use engine\eventSubscribers\payment\SuccessPaymentSubscriber;
use engine\eventSubscribers\payment\ErrorPaymentSubscriber;
use engine\eventSubscribers\smarty\SmartyWidgetsRenderingSubscriber;
use engine\eventSubscribers\widgets\WidgetHandlerEventSubscriber;
use engine\eventSubscribers\system\SystemEventSubscriber;
use engine\eventSubscribers\websocket\PersonalMessagesEventSubscriber;

// Подписываем наши событии, пример "user.registration.successfully/название функции/приоритет" => Ваш Класс::class
$subscribers = array(

    "payment.success.donate/donate/1" => SuccessPaymentSubscriber::class,               //для доната
    "payment.success.sale/sale/1" => SuccessPaymentSubscriber::class,                   //для продажы
    "payment.success.subscription/subscription/1" => SuccessPaymentSubscriber::class,   //для подписок
    "payment.success.pre/successPrePayment/1" => SuccessPaymentSubscriber::class,       //событие после успешной оплаты
    "payment.error.post/errorPaymentPost/1" => ErrorPaymentSubscriber::class,           //ошибка платежа

    //Для рендеринга виджетов в smarty шаблонизаторе
    "smarty.render.payment_widgets/paymentWidgetData/1" => SmartyWidgetsRenderingSubscriber::class,
    "smarty.render.counters/counterWidgetData/1" => SmartyWidgetsRenderingSubscriber::class,
    "smarty.render.participations/participationWidgetData/1" => SmartyWidgetsRenderingSubscriber::class,
    "smarty.render.quiz/quizWidgetData/1" => SmartyWidgetsRenderingSubscriber::class,
    "smarty.render.walls/wallWidgetData/1" => SmartyWidgetsRenderingSubscriber::class,

    //Для события кликов в кастомных виджетах
    "widgets.handle.participation/participationHandle/1" => WidgetHandlerEventSubscriber::class,
    "widgets.handle.quiz/quizHandle/1" => WidgetHandlerEventSubscriber::class,

    //
    "index.beforeInit/indexBeforeInit/1" => SystemEventSubscriber::class,

    //Для событий в websocket
    "ws.onConnect/onConnect/1" => PersonalMessagesEventSubscriber::class,


);