<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    require $_SERVER["DOCUMENT_ROOT"]."/vendor/autoload.php";
    require_once $_SERVER["DOCUMENT_ROOT"]."/engine/mods/load_env.php";

    loadEnv(__DIR__ . '/.env');

    $enabledDatabase = getenv('DB_ENABLED') ?: 'mysql';

    $databaseSettings = [
        'enabled_database' => $enabledDatabase,
        'mysql' => [
            'user' => getenv('DB_USER'),
            'password' => getenv('DB_PASSWORD'),
            'database' => getenv('DB_NAME'),
            'host' => getenv('DB_HOST'),
        ],
        'pgsql' => [
            'user' => getenv('DB_USER'),
            'password' => getenv('DB_PASSWORD'),
            'database' => getenv('DB_NAME'),
            'host' => getenv('DB_HOST'),
        ],
        'mongo' => [],
    ];

    $config["database_settings"] = $databaseSettings;


    use Medoo\Medoo;
    if (!class_exists('DBConfig')) {
        class DBConfig
        {
            private $DB_TYPE = "";
            private $HOST = "";
            private $DATABASE = "";
            private $USER = "";
            private $PASSWORD = "";

            private $db_connect;

            public function setDBType($DBType)
            {
                $this->DB_TYPE = $DBType;
            }

            public function setHOST($HOST)
            {
                $this->HOST = $HOST;
            }

            public function setDATABASE($DATABASE)
            {
                $this->DATABASE = $DATABASE;
            }

            public function setUSER($USER)
            {
                $this->USER = $USER;
            }

            public function setPASSWORD($PASSWORD)
            {
                $this->PASSWORD = $PASSWORD;
            }

            public function __construct()
            {

            }

            public function getDBConnect()
            {
                $this->db_connect = new Medoo([
                    'type' => $this->DB_TYPE,
                    'host' => $this->HOST,
                    'database' => $this->DATABASE,
                    'username' => $this->USER,
                    'password' => $this->PASSWORD
                ]);

                return $this->db_connect;
            }

        }
    }

    global $config;
    try {
        if (!empty($config["database_settings"])) {
            $enabledDatabase = $config["database_settings"]["enabled_database"];
            $currentDatabaseSettings = $config["database_settings"][$enabledDatabase];

            $dbConfig = new DBConfig();
            $dbConfig->setDBType($enabledDatabase);
            $dbConfig->setUSER($currentDatabaseSettings["user"]);
            $dbConfig->setDATABASE($currentDatabaseSettings["database"]);
            $dbConfig->setHOST($currentDatabaseSettings["host"]);
            $dbConfig->setPASSWORD($currentDatabaseSettings["password"]);
            $db_connect = $dbConfig->getDBConnect();
        }

    }catch (Exception $e) {

    }

