<?php

namespace engine\eventSubscribers\payment;

use Subscribers\AbstractEventSubscriber;

class ErrorPaymentSubscriber extends AbstractEventSubscriber
{

    public function errorPaymentPost($eventData, $meta)
    {
        $status = "canceled";

        updateTransactionStatus($_GET["session_id"], $status);

        $transaction = $this->db->get("transactions", "*", ["transaction_id" => $_GET["session_id"]]);

        $widgetId = explode("-", $transaction["action"])[1];

        $widget = $this->db->get("payment_widgets", "*", ["id" => $widgetId]);

        $defaultRedirect = json_decode($widget["settings"], true)["error_url"];

        if (empty($defaultRedirect)) {
            $defaultRedirect = $transaction["default_redirect"];
        }

        return [
            "defaultRedirect" => $defaultRedirect,
            "transaction" => $transaction
        ];

    }

}