<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    use Endroid\QrCode\Builder\Builder;
    use Endroid\QrCode\Encoding\Encoding;
    use Endroid\QrCode\ErrorCorrectionLevel;

    require_once "config.php";

    global $smarty, $APIQrSharingConf;

    function generateQrPngByCode(string $code): string
    {
        global $APIQrSharingConf;

        $payload = $APIQrSharingConf["check_url"] . urlencode($code);
//b3d1948c401da0399a2207388c96789175cd86309772b8d528f0ee43c177f405
        $result = (new Builder())
            ->build(
                data: $payload,
                encoding: new Encoding('UTF-8'),
                errorCorrectionLevel: ErrorCorrectionLevel::High,
                size: 400,
                margin: 20
            );

        return 'data:image/png;base64,' . base64_encode($result->getString());
    }

    function createQrToken(
        $targetType,
        $targetId,
        $regionCode = null,
        $constraints = [],
        $metadata = [],
        ?DateTime $expiresAt = null,
        $usageLimit = 1
    ): array {
        global $db_connect;

        $code = bin2hex(random_bytes(32));

        $db_connect->insert('qr_tokens', [
            'code'             => $code,
            'target_type'      => $targetType,
            'target_id'        => $targetId,
            'region_code'      => $regionCode,
            'constraints_json' => json_encode($constraints, JSON_UNESCAPED_UNICODE),
            'metadata_json'    => json_encode($metadata, JSON_UNESCAPED_UNICODE),
            'expires_at'       => $expiresAt ? $expiresAt->format('Y-m-d H:i:s') : null,
            'usage_limit'      => $usageLimit,
        ]);

        $id = $db_connect->id();

        return [
            'id'   => (int)$id,
            'code' => $code,
        ];
    }





