<?php

    /*
            *****************************************************************************
            * MEGA Digital Space - by MEGA Digital Studio                               *
            * ------------------------------------------------------------------------- *
            * CMS Website:  https://megadigital.space                                   *
            * License:  https://megadigital.space/license                               *
            * Owner:  Giorgi Basharuli                                                  *
            * Contact:  online@megadigital.studio                                       *
            * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
            * Website:  https://megadigital.studio                                      *
            * ------------------------------------------------------------------------- *
            * Description: This file is a part of the MEGA Digital Space CMS system.    *
            * Unauthorized distribution, modification, or commercial use is strictly -  *
            * prohibited without prior written permission.                              *
            * ------------------------------------------------------------------------- *
            * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
            * All rights reserved.                                                      *
            *****************************************************************************
        */

    require_once(ENGINE_DIR . '/data/dbconfig.php');

    require_once(ENGINE_DIR . '/extensions/education/grades/mysqlTables.php');
    require_once(ENGINE_DIR . '/extensions/education/grades/pgsqlTables.php');

    global $config, $db_connect, $createTablesMySql, $createTablesPg;

    $enabledDatabase = $config["database_settings"]["enabled_database"];
    $currentDatabaseSettings = $config["database_settings"][$enabledDatabase];

    $createTables = [];
    if ($enabledDatabase == "mysql") {
        $createTables = $createTablesMySql;
    } elseif ($enabledDatabase == "pgsql") {
        $createTables = $createTablesPg;
    }

    foreach ($createTables as $sql) {
        if (!$db_connect->query($sql)) {
            echo "Ошибка при добавлении таблицы.\n";
            exit;
        }
    }

//    $insertData = [
//
//        // classes
//        "classes" => [
//            ['name' => '1-А'],
//            ['name' => '1-Б'],
//            ['name' => '2-А']
//        ],
//
//        // class_students
//        "class_students" => [
//            ['class_id' => 1, 'student_id' => 10],
//            ['class_id' => 1, 'student_id' => 11],
//            ['class_id' => 2, 'student_id' => 12],
//        ],
//
//        // teacher_classes
//        "teacher_classes" => [
//            ['teacher_id' => 5, 'class_id' => 1],
//            ['teacher_id' => 6, 'class_id' => 2]
//        ],
//
//        /*// event_class_bind
//        "event_class_bind" => [
//            ['event_id' => 1, 'class_id' => 1],
//            ['event_id' => 1, 'class_id' => 2],
//            ['event_id' => 2, 'class_id' => 3]
//        ],*/
//
//    ];
//
//    foreach ($insertData as $table => $rows) {
//        foreach ($rows as $row) {
//            $db_connect->insert($table, $row);
//        }
//    }
//
