<?php

    /*
            *****************************************************************************
            * MEGA Digital Space - by MEGA Digital Studio                               *
            * ------------------------------------------------------------------------- *
            * CMS Website:  https://megadigital.space                                   *
            * License:  https://megadigital.space/license                               *
            * Owner:  Giorgi Basharuli                                                  *
            * Contact:  online@megadigital.studio                                       *
            * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
            * Website:  https://megadigital.studio                                      *
            * ------------------------------------------------------------------------- *
            * Description: This file is a part of the MEGA Digital Space CMS system.    *
            * Unauthorized distribution, modification, or commercial use is strictly -  *
            * prohibited without prior written permission.                              *
            * ------------------------------------------------------------------------- *
            * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
            * All rights reserved.                                                      *
            *****************************************************************************
        */

    require_once(ENGINE_DIR . '/data/dbconfig.php');

    require_once(ENGINE_DIR . '/extensions/education/mysqlTables.php');
    require_once(ENGINE_DIR . '/extensions/education/pgsqlTables.php');

    global $config, $db_connect, $createTablesMySql, $createTablesPg;

    $enabledDatabase = $config["database_settings"]["enabled_database"];
    $currentDatabaseSettings = $config["database_settings"][$enabledDatabase];

    $createTables = [];
    if ($enabledDatabase == "mysql") {
        $createTables = $createTablesMySql;
    } elseif ($enabledDatabase == "pgsql") {
        $createTables = $createTablesPg;
    }

    foreach ($createTables as $sql) {
        if (!$db_connect->query($sql)) {
            echo "Ошибка при добавлении таблицы.\n";
            exit;
        }
    }

    $insertData = [

        // classes
        "classes" => [
            ['name' => '1-А'],
            ['name' => '1-Б'],
            ['name' => '2-А']
        ],

        "roles" => [
            ["name" => "Teacher"],
            ["name" => "Student"],
            ["name" => "Parent"],
        ],

        "permissions" => [
            ['code' => 'edu_classes.view',            'module' => 'view', 'description' => 'Просмотр списка классов'],
            ['code' => 'edu_teachers.view',            'module' => 'view', 'description' => 'Просмотр списка учителей'],
            ['code' => 'edu_students_parents.view',            'module' => 'view', 'description' => 'Просмотр списка учеников и родителей'],

            ['code' => 'edu_classes.create',            'module' => 'create', 'description' => 'Добавление классов'],
            ['code' => 'edu_teachers.create',            'module' => 'create', 'description' => 'Добавление учителей'],
            ['code' => 'edu_students_parents.create',            'module' => 'create', 'description' => 'Добавление учеников и родителей'],

            ['code' => 'edu_classes.update',            'module' => 'update', 'description' => 'Редактирование классов'],
            ['code' => 'edu_teachers.update',            'module' => 'update', 'description' => 'Редактирование учителей'],
            ['code' => 'edu_students_parents.update',            'module' => 'update', 'description' => 'Редактирование учеников и родителей'],

            ['code' => 'edu_classes.del',            'module' => 'del', 'description' => 'Удаление классов'],
            ['code' => 'edu_teachers.del',            'module' => 'del', 'description' => 'Удаление учителей'],
            ['code' => 'edu_students_parents.del',            'module' => 'del', 'description' => 'Удаление учеников и родителей'],

            ['code' => 'grades.view',            'module' => 'view', 'description' => 'Просмотр успеваемости'],
            ['code' => 'grades.create',            'module' => 'create', 'description' => 'Добавление оценок (Успеваемость)'],

            ['code' => 'schedules.view',            'module' => 'view', 'description' => 'Просмотр расписания'],
            ['code' => 'schedules.create',            'module' => 'create', 'description' => 'Создание расписания'],
            ['code' => 'students_progress.create',            'module' => 'create', 'description' => 'Просмоть активности ученика'],
            ['code' => 'students_progress.view',            'module' => 'view', 'description' => 'Создание активности ученика'],
        ]

    ];


    foreach ($insertData as $table => $rows) {
        foreach ($rows as $row) {

            $db_connect->insert($table, $row);

        }
    }

