<?php

    /*
               *****************************************************************************
               * MEGA Digital Space - by MEGA Digital Studio                               *
               * ------------------------------------------------------------------------- *
               * CMS Website:  https://megadigital.space                                   *
               * License:  https://megadigital.space/license                               *
               * Owner:  Giorgi Basharuli                                                  *
               * Contact:  online@megadigital.studio                                       *
               * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
               * Website:  https://megadigital.studio                                      *
               * ------------------------------------------------------------------------- *
               * Description: This file is a part of the MEGA Digital Space CMS system.    *
               * Unauthorized distribution, modification, or commercial use is strictly -  *
               * prohibited without prior written permission.                              *
               * ------------------------------------------------------------------------- *
               * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
               * All rights reserved.                                                      *
               *****************************************************************************
           */

    require_once(ENGINE_DIR . '/data/dbconfig.php');

    require_once(ENGINE_DIR . '/extensions/education/schedules/mysqlTables.php');
    require_once(ENGINE_DIR . '/extensions/education/schedules/pgsqlTables.php');

    global $config, $db_connect, $createTablesMySql, $createTablesPg;

    $enabledDatabase = $config["database_settings"]["enabled_database"];
    $currentDatabaseSettings = $config["database_settings"][$enabledDatabase];

    $uninstall = [
        "DROP TABLE IF EXISTS schedules;",
    ];
    foreach ($uninstall as $sql) {
        if (!$db_connect->query($sql)) {
            echo "Ошибка при удалении таблицы.\n";
            exit;
        }
    }