<?php

    /*
            *****************************************************************************
            * MEGA Digital Space - by MEGA Digital Studio                               *
            * ------------------------------------------------------------------------- *
            * CMS Website:  https://megadigital.space                                   *
            * License:  https://megadigital.space/license                               *
            * Owner:  Giorgi Basharuli                                                  *
            * Contact:  online@megadigital.studio                                       *
            * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
            * Website:  https://megadigital.studio                                      *
            * ------------------------------------------------------------------------- *
            * Description: This file is a part of the MEGA Digital Space CMS system.    *
            * Unauthorized distribution, modification, or commercial use is strictly -  *
            * prohibited without prior written permission.                              *
            * ------------------------------------------------------------------------- *
            * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
            * All rights reserved.                                                      *
            *****************************************************************************
        */

    require_once(ENGINE_DIR . '/data/dbconfig.php');

    require_once(ENGINE_DIR . '/extensions/education/student_progress/mysqlTables.php');
    require_once(ENGINE_DIR . '/extensions/education/student_progress/pgsqlTables.php');

    global $config, $db_connect, $createTablesMySql, $createTablesPg;

    $enabledDatabase = $config["database_settings"]["enabled_database"];
    $currentDatabaseSettings = $config["database_settings"][$enabledDatabase];

    $createTables = [];
    if ($enabledDatabase == "mysql") {
        $createTables = $createTablesMySql;
    } elseif ($enabledDatabase == "pgsql") {
        $createTables = $createTablesPg;
    }

    foreach ($createTables as $sql) {
        if (!$db_connect->query($sql)) {
            echo "Ошибка при добавлении таблицы.\n";
            exit;
        }
    }

    $insertData = [

        // classes
        "progress_categories" => [
            [
                'code' => 'reading',
                'title' => 'Чтение',
                'description' => '',
            ],
            [
                'code' => 'behavior',
                'title' => 'Поведение',
                'description' => '',
            ],
            [
                'code' => 'math',
                'title' => 'Математика',
                'description' => '',
            ]
        ],

    ];

    foreach ($insertData as $table => $rows) {
        foreach ($rows as $row) {

            if (!$db_connect->has($table, [
                "title" => $row
            ])) {
                $db_connect->insert($table, $row);
            }
        }
    }


