<?php

    /*
               *****************************************************************************
               * MEGA Digital Space - by MEGA Digital Studio                               *
               * ------------------------------------------------------------------------- *
               * CMS Website:  https://megadigital.space                                   *
               * License:  https://megadigital.space/license                               *
               * Owner:  Giorgi Basharuli                                                  *
               * Contact:  online@megadigital.studio                                       *
               * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
               * Website:  https://megadigital.studio                                      *
               * ------------------------------------------------------------------------- *
               * Description: This file is a part of the MEGA Digital Space CMS system.    *
               * Unauthorized distribution, modification, or commercial use is strictly -  *
               * prohibited without prior written permission.                              *
               * ------------------------------------------------------------------------- *
               * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
               * All rights reserved.                                                      *
               *****************************************************************************
           */

    require_once(ENGINE_DIR . '/data/dbconfig.php');

    require_once(ENGINE_DIR . '/extensions/education/mysqlTables.php');
    require_once(ENGINE_DIR . '/extensions/education/pgsqlTables.php');

    global $config, $db_connect, $createTablesMySql, $createTablesPg;

    $enabledDatabase = $config["database_settings"]["enabled_database"];
    $currentDatabaseSettings = $config["database_settings"][$enabledDatabase];

    $uninstallMySql = [
        "DROP TABLE IF EXISTS class_students;",
        "DROP TABLE IF EXISTS teacher_classes;",
        "DROP TABLE IF EXISTS event_class_bind;",
        "DROP TABLE IF EXISTS classes;",
        "DROP TABLE IF EXISTS subjects;",
        "DROP TABLE IF EXISTS teacher_subjects;",
        "DROP TABLE IF EXISTS parents_students;",

    ];
    $uninstallPg = [
        "DROP TABLE IF EXISTS class_students;",
        "DROP TABLE IF EXISTS teacher_classes;",
        "DROP TABLE IF EXISTS event_class_bind;",
        "DROP TABLE IF EXISTS classes;",
    ];


    $dropTables = [];
    if ($enabledDatabase == "mysql") {
        $dropTables = $uninstallMySql;
    } elseif ($enabledDatabase == "pgsql") {
        $dropTables = $uninstallPg;
    }

    $permissions = [
        'edu_classes.view',
        'edu_teachers.view',
        'edu_students_parents.view',

        'edu_classes.create',
        'edu_teachers.create',
        'edu_students_parents.create',

        'edu_classes.update',
        'edu_teachers.update',
        'edu_students_parents.update',

        'edu_classes.del',
        'edu_teachers.del',
        'edu_students_parents.del',

        'grades.view',
        'grades.create',

        'schedules.view',
        'schedules.create',
        'students_progress.create',
        'students_progress.view',
    ];

    $db_connect->delete('permissions', [
        'code' => $permissions
    ]);



    foreach ($dropTables as $sql) {
        if (!$db_connect->query($sql)) {
            echo "Ошибка при удалении таблицы.\n";
            exit;
        }
    }