### Описание

1. **`screen_resolution.php`**:
   - Устанавливает заголовок для JSON, чтобы указать, что ответ будет в формате JSON.
   - Получает данные о ширине и высоте экрана из тела запроса, используя `json_decode`.
   - Проверяет наличие данных и сохраняет их в сессии.
   - Возвращает ответ в формате JSON, подтверждая успешное получение данных.

2. **`screen_resolution.js`**:
   - Получает текущую ширину и высоту окна.
   - Отправляет данные на сервер с помощью `fetch`, используя метод POST и формат JSON.
   - Обрабатывает ответ сервера, выводя его в консоль для отладки.

### Установка

1. **Подключите JavaScript**:
   Убедитесь, что вы подключили `screen_resolution.js` к вашему HTML-файлу, чтобы он выполнялся при загрузке страницы. Например:
   ```html
   <script src="engine/ajax/screen_resolution.js"></script>
   ```

2. Используйте данные в вашем Smarty шаблоне

```php
// Присваиваем переменные Smarty
$smarty->assign('screenWidth', $_SESSION['screenWidth'] ?? null);
$smarty->assign('screenHeight', $_SESSION['screenHeight'] ?? null);
```

Теперь вы можете использовать сохраненные в сессии данные о разрешении экрана в вашем Smarty шаблоне. Например:

```smarty
{if $screenWidth < 600}
    <p>Содержимое для маленьких экранов</p>
{elseif $screenWidth < 1200}
    <p>Содержимое для средних экранов</p>
{else}
    <p>Содержимое для больших экранов</p>
{/if}
```