<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Установите заголовки для JSON
    header('Content-Type: application/json');

    // Получаем данные из входящего запроса
    $data = json_decode(file_get_contents('php://input'), true);

    // Проверяем, есть ли данные
    if (isset($data['width']) && isset($data['height'])) {
        $screenWidth = $data['width'];
        $screenHeight = $data['height'];

        // Сохраняем разрешение в сессии или в переменной
        session_start();
        $_SESSION['screenWidth'] = $screenWidth;
        $_SESSION['screenHeight'] = $screenHeight;

        // Возвращаем ответ
        echo json_encode(['status' => 'success']);
    } else {
        // Если данные не получены, возвращаем ошибку
        echo json_encode(['status' => 'error', 'message' => 'Invalid data']);
    }