<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */
    date_default_timezone_set('UTC');

    require_once(__DIR__ . '/../../engine/data/config.php');
    require_once __DIR__ . '/../../vendor/autoload.php';

    require_once(__DIR__ . '/../../engine/jobs/init_job.php');

    mailingLog("CHECK mailing cron start " . date('Y-m-d H:i:s'));

    use Twilio\Rest\Client;

    $twilio = new Client(
        $config["twilio_provider"]["username"],
        $config["twilio_provider"]["password"]
    );
    $twilioFrom = $config["twilio_provider"]["twilio_phone_number"];

    $queueItems = $db_connect->select('mailing_queue', '*', [
        'status[!]' => 'completed',
        'ORDER' => [
            'id' => 'DESC'
        ],
        'LIMIT' => 50
    ]);

    foreach ($queueItems as $queueItem) {
        try {
            $errorMessage = null;

            if (
                $queueItem["channel"] == "sms_text" ||
                $queueItem["channel"] == "text_graphic_sms" ||
                $queueItem["channel"] == "sms_audio"
            ) {
                $message = $twilio->messages($queueItem["provider_message_id"])->fetch();
                $status = $message->status;
                $errorMessage = $message->errorMessage;

            } else if (
                $queueItem["channel"] == "call_audio" ||
                $queueItem["channel"] == "text_to_speech"
            ) {
                $call = $twilio->calls($queueItem["provider_message_id"])->fetch();
                $status = $call->status;
            }

            $db_connect->update("mailing_queue", [
                'status' => $status,
                'error'  => $errorMessage
            ], [
                "id" => $queueItem["id"]
            ]);

        } catch (Exception $exception) {
            $db_connect->update("mailing_queue", ['status' => "failed", 'error' => $exception->getMessage()], [
                "id" => $queueItem["id"]
            ]);
        }

    }



