<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    define('ENGINE_DIR', $_SERVER['DOCUMENT_ROOT'] . '/engine');
    
    // Подключение к базе данных через конфиг
    require_once(ENGINE_DIR . '/data/config.php');
    
    // Подключение Smarty
    require_once(ENGINE_DIR . '/libs/Smarty.class.php');
    $smarty = new Smarty;
    $smarty->setCompileDir($_SERVER['DOCUMENT_ROOT'] . '/templates_c');

    // URL официального сайта для проверки лицензии
    $official_site_url = 'https://megadigital.space/check_license.php';
    
    // Функция для проверки лицензионного ключа
    function check_license($license_key, $official_site_url) {
        global $db_connect, $smarty, $config;
        // Определение текущего домена автоматически через серверные переменные
        $current_domain = $_SERVER['HTTP_HOST']; // Или $_SERVER['SERVER_NAME'], если хотите использовать другое
    
        // Формирование данных для отправки на официальный сайт
        $postData = [
            'license_key' => $license_key,
            'domain' => $current_domain,
        ];
    
        // Инициализация cURL для выполнения запроса на официальный сайт
        $ch = curl_init($official_site_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
        
        // Устанавливаем тайм-аут для cURL запроса (опционально)
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
        // Выполнение запроса
        $response = curl_exec($ch);
    
        // Логирование информации для отладки
        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
            curl_close($ch);
            return ["status" => "error", "message" => "Ошибка cURL: " . $error_msg];
        }

        // Логируем исходный ответ
        error_log("Ответ сервера (оригинал): " . $response);

        curl_close($ch);
    
        // Проверка результата запроса
        if ($response === false) {
            return ["status" => "error", "message" => "Ошибка: Пустой ответ от сервера."];
        }
    
        // Декодируем JSON-ответ от сервера
        $result = json_decode($response, true);
    
        // Проверяем, удалось ли корректно декодировать JSON
        if (json_last_error() !== JSON_ERROR_NONE) {
            return ["status" => "error", "message" => "Ошибка: Некорректный ответ от сервера. Не удалось декодировать JSON. Ошибка: " . json_last_error_msg()];
        }
    
        // Логируем декодированный ответ для отладки
        error_log("Ответ сервера (декодированный): " . print_r($result, true));
    
        // Проверяем статус лицензии
        if (isset($result['status']) && $result['status'] === 'valid') {
            return ["status" => "valid", "version" => $result['version'], "created_date" => $result['created_date']];
        } elseif (isset($result['error'])) {
            return ["status" => "invalid", "message" => $result['error']];
        }
    
        return ["status" => "error", "message" => "Ошибка: Не удалось проверить лицензионный ключ. Ответ сервера: " . $response];
    }
    
    // Передаем данные в Smarty
    $smarty->assign('engine', $config['engine']);
    $smarty->assign('stheme', $config['stheme']);
    $smarty->assign('title', $config['title']);
    $smarty->assign('charset', $config['charset']);
    $smarty->assign('generator', $config['generator']);
    $smarty->assign('keywords', $config['keywords']);
    $smarty->assign('description', $config['description']);
    
    // Проверка наличия данных в POST запросе
    if (empty($_POST['license_key'])) {
        $smarty->assign('error_message', 'Ошибка: Лицензионный ключ не передан.');
        $smarty->display(ENGINE_DIR . '/license/error.tpl');
        exit;
    }
    
    // Пример использования функции проверки
    $license_key = $_POST['license_key'];
    
    // Вызов функции проверки лицензии
    $license_check_result = check_license($license_key, $official_site_url);
    
    if ($license_check_result['status'] === 'valid') {
        // Обновление конфигурационного файла с новым лицензионным ключом
        $config['license'] = $license_key;
    
        // Обновляем конфигурацию в зависимости от версии
        if (isset($license_check_result['version'])) {
            // Устанавливаем version_type в зависимости от version
            if ($license_check_result['version'] === 'yearly') {
                $config['version_type'] = 'yearly';
            } elseif ($license_check_result['version'] === 'lifetime') {
                $config['version_type'] = 'lifetime';
            } else {
                $config['version_type'] = 'Unlicensed';
            }
    
            // Записываем дату создания лицензии форматируя дату с 2024-09-18 на 09-18-2024
            if (isset($license_check_result['created_date'])) {
                $original_date = $license_check_result['created_date'];
                $formatted_date = date('m-d-Y', strtotime($original_date));
                $config['created_date'] = $formatted_date;
            } else {
                $config['created_date'] = null;
            }
        } else {
            $config['version_type'] = 'Unlicensed';
            $config['created_date'] = null;
        }
    
        // Сохранение данных в конфиг
        $configFilePath = ENGINE_DIR . '/data/config.php';
        $configContent = '<?php $config = ' . var_export($config, true) . ';';
        $configContent = preg_replace("/=>\s*array/", "=> array", $configContent);
        file_put_contents($configFilePath, $configContent, LOCK_EX);
    
        // Переадресация на страницу подтверждения
        $smarty->assign('success_message', 'Лицензия успешно проверена.');
        $smarty->display(ENGINE_DIR . '/license/success.tpl');

        $license_folder = ENGINE_DIR . '/license';
        require_once(ENGINE_DIR . '/mods/delete_directory.php');
        deleteDirectory($license_folder);

        $templates_c_folder = $_SERVER['DOCUMENT_ROOT'] . '/templates_c';
        require_once(ENGINE_DIR . '/mods/delete_directory.php');
        deleteDirectory($templates_c_folder);
    } else {
        $smarty->assign('error_message', $license_check_result['message']);
        $smarty->display(ENGINE_DIR . '/license/error.tpl');
    }