<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Получаем абсолютный путь к текущему файлу
    $current_file_path = __DIR__;

    if (isset($_SERVER['HTTP_REFERER'])) {
        $referer = $_SERVER['HTTP_REFERER'];

        // Проверяем, содержит ли HTTP_REFERER указанный префикс для административной панели
        if (strpos($referer, '/admin') !== false) {
            // Если да, используем относительный путь от корня сайта для административной панели
            require_once($current_file_path . '/../engine/data/dbconfig.php');
        } else {
            // Иначе, используем абсолютный путь для пользовательской части сайта
            require_once('engine/data/dbconfig.php');
        }
    }

    if(session_status() == PHP_SESSION_NONE) {
        session_start();
    }

    //google and facebook auth login urls gen
    require_once(ENGINE_DIR.'/mods/google_api.php');
    require_once(ENGINE_DIR.'/mods/facebook_api.php');

    $avatar = '';

    $base_url = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
    $base_url .= "://" . $_SERVER['HTTP_HOST'];

    // Сохраняем URL, с которого пришел запрос, в сессии
    if (isset($_SERVER['HTTP_REFERER']) && strpos($_SERVER['HTTP_REFERER'], "admin") !== false) {
        $_SESSION['referer'] = $_SERVER['HTTP_REFERER'];
    }
    $userSubscription = "No subscription";

    // Проверяем, отправлена ли форма для авторизации
    // Проверяем, отправлена ли форма для авторизации
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['user_email']) && isset($_POST['user_password']) && isset($_POST['login_submit'])) {
        // Обработка данных из формы
        $email = $_POST['user_email'];
        $password = $_POST['user_password'];
        $remember = isset($_POST['remember_me']); // Проверка, установлен ли чекбокс "Запомнить меня"

        // Используем Medoo для выполнения запроса
        $user = $db_connect->get('users', '*', ['email' => $email]);

        $userRole = $db_connect->get("users_roles", "*", ["user_id" => $user["id"]]);

        if ($user) {
            if (empty($user["referral_code"])) {
                $referralCode = bin2hex(random_bytes(6));
                $db_connect->update("users", ['referral_code' => $referralCode], ['email' => $email]);
            }

            // Проверка пароля
            $hashed_password = $user['password'];
            if (password_verify($password, $hashed_password)) {
                // Устанавливаем переменные сессии
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_name'] = $user['name'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['user_authenticated'] = true;
                $_SESSION['user_group_id'] = $userRole['role_id'];

                // Обновляем путь к аватарке с полным URL
                $avatar = $user['avatar'];
                if (!empty($avatar)) {
                    $avatar = "{$base_url}/{$avatar}";
                } else {
                    $avatar = "{$base_url}/uploads/profiles/default.svg";
                }

                // Устанавливаем cookies, если выбран "Запомнить меня"
                if ($remember) {
                    setcookie('id', $user['id'], time() + (86400 * 30), "/"); // 30 дней
                    setcookie('user_id', $user['id'], time() + (86400 * 30), "/"); // 30 дней
                    setcookie('user_email', $user['email'], time() + (86400 * 30), "/");
                    setcookie('user_name', $user['name'], time() + (86400 * 30), "/");
                   // setcookie('user', $user, time() + (86400 * 30), "/");
                    setcookie('avatar', $avatar, time() + (86400 * 30), "/");
                    setcookie('user_group_id', $userRole['role_id'], time() + (86400 * 30), "/");
                    setcookie('logged_in', 'true', time() + (86400 * 30), "/");
                    setcookie('user_authenticated', true, time() + (86400 * 30), "/");
                    setcookie('user_balance', $user["balance"], time() + (86400 * 30), "/");
                    $jsonData = json_encode($user); // Преобразование массива в строку JSON

                    setcookie('user', $jsonData, time() + (86400 * 30), "/");
                    setcookie('currency', getCurrentCurrency(), time() + (86400 * 30), "/");

                }

                // Определяем, куда перенаправить пользователя после авторизации
                if (isset($_SESSION['referer'])) {
                    $redirectUrl = $_SESSION['referer'];
                    unset($_SESSION['referer']); // Удаляем URL из сессии после использования
                } else {
                    $redirectUrl = '/';
                }

                // Перенаправляем пользователя
                header("Location: $redirectUrl");
                exit();
            } else {
                // Неверный пароль
                $user = [];
                $error_message = "Неверный пароль";
            }
        } else {
            // Пользователь с таким email не найден
            $error_message = "Пользователь с таким email не найден";
        }
    }

    // Проверка на наличие куков для автоматической авторизации
    if (!empty($_COOKIE['user_id']) && !empty($_COOKIE['user_email'])) {
        $_SESSION['user_id'] = $_COOKIE['user_id'];
        $_SESSION['user_email'] = $_COOKIE['user_email'];
        $_SESSION['user_name'] = $_COOKIE['user_name'];
        $_SESSION['user_authenticated'] = true;
        $userRole = $db_connect->get("users_roles", "*", ["user_id" => $_SESSION["user_id"]]);

        $_SESSION['user_group_id'] = $_COOKIE['user_group_id'];
        $userGroup = $_SESSION["user_group_id"];
        require_once ENGINE_DIR."/mods/user_rules.php";

        $userBalance = $db_connect->get("users", "balance", ["id" => $_SESSION["user_id"]]);
        $user["balance"] = $userBalance;
        $_SESSION['user_balance'] = convertAmount($userBalance, $config["payment_info"]["default_currency"], getCurrentCurrency());
        $_SESSION['user'] = json_decode($_COOKIE['user'], true);
        //$_SESSION['currency'] = $_COOKIE['currency'];
        $_SESSION['user']['balance'] = convertAmount($userBalance, $config["payment_info"]["default_currency"], getCurrentCurrency());
        if (empty($_SESSION["currency"])) {
            $_SESSION["currency"] = $_COOKIE["currency"];
        } else {
            $_COOKIE["currency"] = $_SESSION["current_currency"] ?? "RUB";
        }


        // Получаем дополнительную информацию о пользователе
         $user = $db_connect->get('users', '*', ['id' => $_SESSION['user_id']]);

        if ($user) {
            $_SESSION['user_group_id'] = $userRole['role_id'];
            $avatar = !empty($user['avatar']) ? "{$base_url}/{$user['avatar']}" : "{$base_url}/uploads/profiles/default.svg";
        }

        if ($user) {

            $user["role_id"] = $db_connect->get("users_roles", "role_id", ["user_id" => $_SESSION['user_id']]);

            $role = $db_connect->get("roles", [
                "name"
            ], [
                "id" => $user['role_id']
            ]);

            $user['role_name'] = $role['name'] ?? 'Без роли';

        } else {
            // Пользователь не найден
        }



    }
    $subscriptionLeftDays = null;
    $avatar = !empty($user['avatar']) ? "{$base_url}/{$user['avatar']}" : "{$base_url}/uploads/profiles/default.svg";

    if ($user["auth_source"] == "google" || $user["auth_source"] == "facebook") {
        $avatar = str_replace('s96-c', 's200', $user["avatar"]);
    }

    if (isset($user) && !empty($user)) {
        $userSubscription = $db_connect->get("user_subscriptions", "*", ["user_id" => $user['id']]);
        if (!empty($userSubscription)) {
            $targetDate = new DateTime($userSubscription["end_date"]);
            $today = new DateTime();

            $interval = $today->diff($targetDate);

            if ($targetDate < $today) {
                $subscriptionLeftDays = "EXPIRED";
                $db_connect->delete("user_subscriptions", ["user_id" => $user['id']]);
            } else {
                $subscriptionLeftDays = "left days - ".$interval->days;
            }

            $userSubscription = $db_connect->get("subscriptions", "name", ["id" => $userSubscription['subscription_id']]);
        } else {
            $userSubscription = "No subscription";
        }
    }

    $rulesForAdd = [];
    if (!empty($user)) {
        foreach ($config["rules_of_add"] as $object => $rulesOfAdd) {
            foreach ($rulesOfAdd as $groupId) {
                if ($groupId == $userRole["role_id"]) {
                    $rulesForAdd[] = $object;
                }
            }
        }
    }

    $smarty->assign('rulesForAdd', $rulesForAdd);
    $smarty->assign('user_balance', $_SESSION["user_balance"] ?? $user["balance"] ?? "");
    $smarty->assign('currency', $_SESSION['currency'] ?? getCurrentCurrency());
    $smarty->assign('group_name', $db_connect->get("roles", "name", ["id" => $userRole["role_id"]]) ?? null);
    $smarty->assign('user', $user ?? null);
    $smarty->assign("userSubscription", $userSubscription);
    $smarty->assign("subscriptionLeftDays", $subscriptionLeftDays);

    // Обновляем данные для отображения в шаблоне
    $smarty->assign('user_authenticated', isset($_SESSION['user_authenticated']) && $_SESSION['user_authenticated']);
    $smarty->assign('user_name', $user['name'] ?? null);
    $smarty->assign('user_email', $_SESSION['user_email'] ?? null);
    $smarty->assign('user_group_id', $user['role_id'] ?? $_SESSION["user_group_id"] ?? null);
    $smarty->assign('avatar', $avatar == "" ? "{$base_url}/uploads/profiles/default.svg" : $avatar);
    $smarty->assign('error_message', $error_message ?? null);
    $smarty->assign('base_url', $base_url);
    $smarty->assign('login', $smarty->fetch(TEMPLATES_DIR . '/' . $config['skin'] . '/login.tpl'));
