<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    $apiKey = '246e638a3df4641e980410b3';
    $apiUrl = 'https://v6.exchangerate-api.com/v6/' . $apiKey . '/latest/USD';
    $jsonFile = ENGINE_DIR."/data/".'exchange_rates.json';

    $storedData = [];
    if (file_exists($jsonFile)) {
        $storedData = json_decode(file_get_contents($jsonFile), true);
    }

    if (empty($storedData) || $storedData['date'] !== date('Y-m-d')) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'Ошибка cURL: ' . curl_error($ch);
        } else {
            $data = json_decode($response, true);

            if (isset($data['conversion_rates'])) {
                $usdToEur = $data['conversion_rates']['EUR'];
                $usdToRub = $data['conversion_rates']['RUB'];
                $currentDate = date('Y-m-d');

                $data['conversion_rates'][$config['currency_title']] = $data['conversion_rates']['USD'];

                $newData = [
                    'date' => $currentDate,
                ];
                foreach ($data["conversion_rates"] as $key => $rate) {
                    if (in_array($key, $config["payment_info"]["included_currencies"]) && $config["payment_info"]["show_all_currencies"] === false) {
                        $newData["rates"][$key] = $rate += $config["payment_info"]["currencies_custom_values"][$key] ?? 0;
                    } else if ($config["payment_info"]["show_all_currencies"] === true) {
                        $newData["rates"][$key] = $rate += $config["payment_info"]["currencies_custom_values"][$key] ?? 0;
                    }
                }



                file_put_contents($jsonFile, json_encode($newData));
            } else {
                echo "Ошибка в получении данных о курсах валют.";
            }
        }

        curl_close($ch);
    }
