<?php

    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */
    date_default_timezone_set('UTC');

    function checkCommentBannedWords($comment, $commentId)
    {

        global $db_connect, $config;

        $bannedWords = $db_connect->select("banned_words", "word");

        $found = false;

        $bannedWord = "";
        foreach ($bannedWords as $word) {
            $pattern = '/(?<!\p{L})' . preg_quote($word, '/') . '(?!\p{L})/iu';
            if (preg_match($pattern, $comment)) {
                $found = true;
                $bannedWord = $word;
                break;
            }
        }

        if ($found) {
            $db_connect->insert("punishment_logs", [
                "user_id" => $_SESSION['user_id'] ?? null,
                "ip_address" => $_SERVER['REMOTE_ADDR'],
                "comment_id" => $commentId,
                "banned_word" => $bannedWord,
            ]);

            $punishmentLog = $db_connect->get("punishment_logs", "*", [
                "id" => $db_connect->id()
            ]);

            $punishmentType = $db_connect->get("punishment_types", "*", ["name" => "30 Минут"]);

            if ($config["auto_ban_commenting"] === true) {
                banUserCommenting($punishmentLog["id"], $punishmentType["id"]);
            }

            $db_connect->update("comments", [
                "status" => 0,
            ], ["id" => $commentId]);
        } else {
            return false;
        }

    }

    function checkIsAccessComment()
    {
        global $db_connect, $smarty;

        $userPunishment = $db_connect->get("user_punishments", "*", [
            "OR" => [
                "user_id"   => $_SESSION['user_id'] ?? null,
                "ip_address"=> $_SERVER['REMOTE_ADDR'] ?? null,
            ]
        ]);

        if (!empty($userPunishment)) {
            $now = new DateTime('now', new DateTimeZone('UTC'));
            $unlockDate = new DateTime($userPunishment["expires_at"], new DateTimeZone('UTC'));

            if ($now >= $unlockDate) {
                return true;
            } else {
                $smarty->assign("commentingBlocked", true);
                $smarty->assign("punishmentDuration", $db_connect->get("punishment_types", "name", ["id" => $userPunishment["punishment_type_id"]]));

                return false;

            }
        }
        $smarty->assign("commentingBlocked", false);

        return true;
    }

    function banUserCommenting($plID, $punishmentType)
    {
        global $db_connect;

        $punishmentLog = $db_connect->get("punishment_logs", "*", [
            "id" => (int)$plID,
        ]);

        $banDurationSeconds = (int)$db_connect->get("punishment_types", "duration_seconds", [
            "id" => (int)$punishmentType,
        ]);

        $expiresAt = $banDurationSeconds > 0
            ? date('Y-m-d H:i:s', time() + $banDurationSeconds)
            : date('Y-m-d H:i:s', strtotime('+100 years'));

        $existsUserPunishment = $db_connect->get("user_punishments", "*", [
            "OR" => [
                "user_id"   => $punishmentLog['user_id'] ?? null,
                "ip_address"=> $punishmentLog["ip_address"] ?? null,
            ]
        ]);

        if (!empty($existsUserPunishment)) {

            $db_connect->update("user_punishments", [
                "expires_at" => $expiresAt,
            ], ["id" => $existsUserPunishment["id"]]);

        } else {
            $db_connect->insert("user_punishments", [
                "punishment_type_id" => (int)$punishmentType,
                "ip_address"         => $punishmentLog["ip_address"],
                "user_id"            => (int)$punishmentLog["user_id"],
                "comment_id"         => (int)$punishmentLog["comment_id"],
                "expires_at"         => $expiresAt,
            ]);
        }

        $db_connect->update("punishment_logs", [
            "punishment_id" => (int)$db_connect->id(),
        ], [
            "id" => (int)$punishmentLog["id"],
        ]);
    }

