<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    function generateBindings($moduleName, $defaultPageName)
    {
        global $db_connect, $lang, $smarty;


        // получаем binding из БД
        $bindings = $db_connect->get("bindings", "*", [
            "module_name" => $moduleName
        ]);

        if (!empty($bindings)) {
            // создаем ссылку из binding
            $bindingLink = '<li class="breadcrumb-item">
                    <a href="' . $bindings['parent_url'] . '">' .
                ($lang[$bindings["translate_parent"]][$bindings["translate_child"]] ?? $bindings["binding_name"]) .
                '</a>
                </li>';

            // конкатенируем с дефолтным
            $smarty->assign('page_name', $bindingLink . $defaultPageName);
        } else {
            // если binding нет — просто дефолт
            $smarty->assign('page_name', $defaultPageName);
        }
    }
