<?php
    /*
            *****************************************************************************
            * MEGA Digital Space - by MEGA Digital Studio                               *
            * ------------------------------------------------------------------------- *
            * CMS Website:  https://megadigital.space                                   *
            * License:  https://megadigital.space/license                               *
            * Owner:  Giorgi Basharuli                                                  *
            * Contact:  online@megadigital.studio                                       *
            * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
            * Website:  https://megadigital.studio                                      *
            * ------------------------------------------------------------------------- *
            * Description: This file is a part of the MEGA Digital Space CMS system.    *
            * Unauthorized distribution, modification, or commercial use is strictly -  *
            * prohibited without prior written permission.                              *
            * ------------------------------------------------------------------------- *
            * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
            * All rights reserved.                                                      *
            *****************************************************************************
        */

    /**
     * Универсальный генератор breadcrumbs / page_name
     * Работает для любого количества уровней
     */
    function generateBreadcrumbs($db_connect, $lang = [], $currentUrl = null, $custom = []) {
        if (!$currentUrl) {
            $currentUrl = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        }
        $currentUrl = rtrim($currentUrl, '/');
        $segments = explode('/', trim($currentUrl, '/'));
        $breadcrumbs = [];
        $accumUrl = '';

        // кастомные элементы сверху
        foreach ($custom as $c) {
            $breadcrumbs[] = [
                'title' => $c['title'],
                'url'   => $c['url'] ?? null
            ];
        }

        // текущий хост (для фильтрации, если в bindings есть site/host поле)
        $host = $_SERVER['HTTP_HOST'] ?? null;

        for ($i = 0; $i < count($segments); $i++) {
            $seg = $segments[$i];
            $accumUrl .= '/' . $seg;

            // получить все привязки для этого parent_url
            $bindings = $db_connect->select('bindings', '*', [
                'parent_url' => $accumUrl
            ]);

            $binding = null;

            if (!empty($bindings)) {
                // 1) если есть записи с переводами — предпочитаем их (чаще это точная нужная привязка)
                foreach ($bindings as $b) {
                    if (!empty($b['translate_parent']) && !empty($b['translate_child'])) {
                        $binding = $b;
                        break;
                    }
                }

                // 2) если ещё не выбрали, попробуем по совпадению хоста/site (если в таблице есть такое поле)
                if (!$binding && $host) {
                    foreach ($bindings as $b) {
                        if (!empty($b['site']) && strpos($host, $b['site']) !== false) {
                            $binding = $b;
                            break;
                        }
                        // иногда поле называется 'host' или 'domain' - проверим
                        if (!empty($b['host']) && strpos($host, $b['host']) !== false) {
                            $binding = $b;
                            break;
                        }
                    }
                }

                // 3) если есть поле priority или weight — берём максимальную
                if (!$binding) {
                    $bestPriority = null;
                    foreach ($bindings as $b) {
                        if (isset($b['priority'])) {
                            if ($bestPriority === null || (int)$b['priority'] > (int)$bestPriority['priority']) {
                                $bestPriority = $b;
                            }
                        }
                    }
                    if ($bestPriority) {
                        $binding = $bestPriority;
                    }
                }

                // 4) последний вариант — берём запись с наибольшим id (последняя добавленная)
                if (!$binding) {
                    usort($bindings, function($a, $b) {
                        $ida = isset($a['id']) ? (int)$a['id'] : 0;
                        $idb = isset($b['id']) ? (int)$b['id'] : 0;
                        return $idb <=> $ida;
                    });
                    $binding = $bindings[0];
                }
            }

            $name = '';

            if (!empty($binding)) {
                // если binding имеет перевод — используем его
                if (!empty($binding["translate_parent"]) && !empty($binding["translate_child"])
                    && isset($lang[$binding["translate_parent"]][$binding["translate_child"]])
                ) {
                    $name = $lang[$binding["translate_parent"]][$binding["translate_child"]];
                } elseif (!empty($binding['binding_name'])) {
                    $name = $binding['binding_name'];
                }
            }

            // если ничего не нашли — делаем читаемое имя из сегмента
            if (!$name) {
                // если сегмент числовой (id) — попробуем взять предыдущую запись как родителя (если есть кастом поле)
                if (is_numeric($seg) && !empty($breadcrumbs)) {
                    // оставляем как числовой, можно расширить: подгружать title по id из БД
                    $name = $seg;
                } else {
                    $name = ucfirst(str_replace(['-', '_'], ' ', $seg));
                }
            }

            $breadcrumbs[] = [
                'title' => $name,
                'url'   => $accumUrl
            ];
        }

        // формируем HTML (Bootstrap-совместимые элементы)
        $page_name_html = '';
        foreach ($breadcrumbs as $idx => $b) {
            // последний элемент — активный без ссылки
            if ($idx === count($breadcrumbs) - 1) {
                $page_name_html .= '<li class="breadcrumb-item active" aria-current="page">' . htmlspecialchars($b['title']) . '</li>';
            } else {
                $page_name_html .= '<li class="breadcrumb-item"><a href="' . htmlspecialchars($b['url']) . '">' . htmlspecialchars($b['title']) . '</a></li>';
            }
        }

        return $page_name_html;
    }

    function generatePageTitle($db_connect, $lang = [], $currentUrl = null) {

        global $config;

        if (!$currentUrl) {
            $currentUrl = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        }

        $currentUrl = rtrim($currentUrl, '/');

        // ищем binding для всей страницы
        $binding = $db_connect->get('bindings', '*', [
            'parent_url' => $currentUrl,
            'ORDER' => ['id' => 'DESC']
        ]);

        $name = '';

        if (!empty($binding)) {
            if (!empty($binding["translate_parent"]) && !empty($binding["translate_child"])) {
                $name = $lang[$binding["translate_parent"]][$binding["translate_child"]];
            } else {
                $name = $binding['binding_name'];
            }
        }

        // fallback если нет привязки
        if (!$name) {
            $segments = explode('/', trim($currentUrl, '/'));
            $last = end($segments);
            $name = ucfirst(str_replace(['-', '_'], ' ', $last));
        }

        // финальный формат
        return $name . " | ".$config['title'];
    }



