<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

$payed = true;
if (isset($user) && !empty($user["id"]) && $config["enable_payed_roles"] === true) {
    $userSubscription = $db_connect->get("user_subscriptions", "*", ["user_id" => $user["id"]]);
    if (!empty($userSubscription)) {
        $db_connect->update("user_applications", [
            "payed_status" => "payed",
        ], ["user_id" => $user["id"]]);
    }
    $userAppData = $db_connect->get("user_applications", "*", ["user_id" => $user["id"]]);

    if (!empty($userAppData)) {
        $appGroup = $db_connect->get("roles", "name", ["id" => $userAppData["group_id"]]);
        if ($userAppData["payed_status"] == "progress" && !empty($appGroup)) {
            $payed = false;

            if (!empty($config["payed_roles"][$appGroup])) {
                $sumYear = convertAmount($config["payed_roles"][$appGroup]["yearly"], $config["payment_info"]["default_currency"], getCurrentCurrency());
                $sumMonth = convertAmount($config["payed_roles"][$appGroup]["monthly"], $config["payment_info"]["default_currency"], getCurrentCurrency());
                $widget = $db_connect->get("payment_widgets", "id", ["name" => "Payed Group-".$user["id"]]);

                if(empty($widget)) {
                    $db_connect->insert("payment_widgets", [
                        "name" => "Payed Group-".$user["id"],
                        "price" => $config["payed_roles"][$appGroup]["yearly"],
                        "price_model" => 0,
                        "w_type" => "sale",
                        "p_type" => "one_time",
                        "period" => "once",
                        "notify_fr" => "once",
                        "limit" => 1000,
                        "edited" => 0,
                        "template_name" => "universal-payment",
                        "disable_promo" => 1,
                        "disable_delivery" => 1,
                        "super_donater_sum" => 0,
                        "disable_title" => 1,
                        "pay_with_redirect" => 1,
                        "settings" => json_encode([
                            "email_template" => false,
                            "statistic_counter" => false,
                            "account_required" => true,
                            "success_url" => "/profile",
                            "error_url" => "/profile",
                            "api_key" => "",
                            "group_field" => "",
                            "redirect_to_registration" => false,
                        ])
                    ]);
                    $widget = $db_connect->id();
                }


                $smarty->assign("widget", $widget);
                $smarty->assign("payedRole", $appGroup);
                $smarty->assign("payedRoleSumM", $sumMonth);
                $smarty->assign("payedRoleSumY", $sumYear);
            } else {
                $payed = true;
            }
        }
    }

}
$smarty->assign("payed", $payed);
