<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

	if (empty($folder)) {
		$error_message = "Не указаны необходимые параметры.";
		$smarty->assign('error_message', $error_message);
		return; // Завершаем выполнение скрипта
	}
	
	$image = '';
	$error_message = ''; // Добавляем переменную для хранения сообщений об ошибках
	
	// Проверка загруженного изображения
	if (isset($_FILES['image']) && $_FILES['image']['error'] == UPLOAD_ERR_OK) {
		$dir = 'uploads/images/' . $folder . '/' . date('Y') . '/' . date('m') . '/';
		$uploadDir = $_SERVER['DOCUMENT_ROOT'] . '/' . $dir;
	
		if (!is_dir($uploadDir)) {
			mkdir($uploadDir, 0777, true);
		}
	
		$file_count = count(scandir($uploadDir)) - 1;
		$imageName = $p_id . '_' . $file_count . '_' . basename($_FILES['image']['name']);
		$imagePath = $uploadDir . $imageName;
	
		if (move_uploaded_file($_FILES['image']['tmp_name'], $imagePath)) {
			$image = $dir . $imageName;
		} else {
			$error_message = "Не удалось переместить загруженный файл.";
		}
	}
	
	// Если новое изображение не загружено, используем текущее значение из БД (если оно есть)
	if (empty($image)) {
        $stmtimage = $db_connect->get($folder, "*", ["id" => $p_id]);

        $image = $stmtimage["image"];

		if ($stmtimage === false) {
			$error_message = "MySQL prepare statement failed: " . $db_connect->error;
		}
	}
	
	// Теперь обновляем запись в базе данных
	/*$updateSql = "UPDATE $folder SET image = ? WHERE id = ?";
	$stmtupdate = $db_connect->prepare($updateSql);*/

    $stmtupdate = $db_connect->update($folder, [
        "image" => $image,
    ], ["id" => $p_id]);
	
	if ($stmtupdate === false) {
		$error_message = "MySQL prepare statement failed: " . $db_connect->error;
	}
	
	// Передаем сообщение об ошибке в Smarty
	$smarty->assign('error_message', $error_message);