<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    function fetch_comments($entity_id, $entity_type) {
        global $db_connect;
        // Получение всех комментариев для сущности
        $comments = $db_connect->select('comments', '*', [
            'entity_id' => $entity_id,
            'entity_type' => $entity_type,
            'status' => 1
        ]);

        // Получение комментариев-предков для добавления информации о родительских авторах
        $parent_ids = array_filter(array_column($comments, 'parent_id'));
        $parents = [];
        if ($parent_ids) {
            $parents = $db_connect->select('comments', ['id', 'author'], [
                'id' => $parent_ids
            ]);
        }

        // Формируем массив комментариев с добавленными родительскими авторами
        $comments_data = [];
        foreach ($comments as $comment) {
            $comments_data[$comment['id']] = $comment;
            if ($comment['parent_id'] !== NULL) {
                $parent_author = array_column($parents, 'author', 'id');
                $comments_data[$comment['id']]['parent_author'] = $parent_author[$comment['parent_id']] ?? null;
            }
        }

        return $comments_data;
    }

    function build_comment_tree(&$comments) {
        $tree = [];
        foreach ($comments as $id => &$comment) {
            if ($comment['parent_id'] === NULL) {
                $tree[$id] = &$comment;
            } else {
                if (!isset($comments[$comment['parent_id']]['replies'])) {
                    $comments[$comment['parent_id']]['replies'] = [];
                }
                $comments[$comment['parent_id']]['replies'][$id] = &$comment;
            }
        }
        return $tree;
    }

    // Обработка добавления комментария
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'add_comment') {
        require_once ENGINE_DIR.'/mods/banned_words_detector.php';

        if (!checkIsAccessComment()) {
            header("Location: " . $_SERVER['REQUEST_URI']);
            exit;
        }

        // Получаем максимальное значение id из таблицы комментариев
        $sql = "SELECT MAX(id) AS max_id FROM comments";
        $result_max_id = $db_connect->query($sql);
        if ($result_max_id->num_rows > 0) {
            while($row = $result_max_id->fetch_assoc()) {
                $max_id = $row["max_id"];
            }
        } else {
            $max_id = 0;
        }
        // Сбрасываем счетчик автоинкремента к максимальному значению id комментариев
        //$sql_reset_auto_increment = "ALTER TABLE comments AUTO_INCREMENT = " . ($max_id + 1);
       // $db_connect->query($sql_reset_auto_increment);
        $entity_id = intval($_POST['entity_id']);
        $entity_type = trim($_POST['entity_type']);
        $author = trim($_POST['author']);
        $content = trim($_POST['content']);
        $parent_id = isset($_POST['parent_id']) ? intval($_POST['parent_id']) : NULL;

        // Вставляем комментарий в базу данных
        $data = [
            'entity_id'   => $entity_id,
            'entity_type' => $entity_type,
            'author'      => $author,
            'comment_text'=> $content,
            'parent_id'   => $parent_id,
            'created_at'  => null // NOW() будет установлено на уровне базы данных
        ];

        if (!empty($_SESSION["user_id"])) {
            $data["user_id"] = $_SESSION["user_id"];
            $data["status"] = 1;
        } else {
            $data["status"] = 0;
        }

        // Вставка данных в таблицу comments
        $result = $db_connect->insert('comments', $data);
        $commentId = $db_connect->id();

        $isFoundBannedWork = checkCommentBannedWords($content, (int)$commentId);


        // Проверка результата выполнения вставки
        if ($result) {
            echo "Комментарий успешно добавлен!";
        } else {
            echo "Ошибка при добавлении комментария.";
        }
        // Перенаправление для предотвращения повторной отправки формы
        header("Location: " . $_SERVER['REQUEST_URI']);
        exit;
    }