<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once(ENGINE_DIR . '/data/config.php');
require_once(ENGINE_DIR . '/mods/currency.php');
require_once(ENGINE_DIR."/mods/database_helper.php");

function getConvertedBalanceInfo()
{
    global $config, $db_connect, $smarty;

    require_once(ENGINE_DIR . '/mods/check_is_auth.php');
    $userData = $db_connect->get("users", "*", ["email" => $_SESSION['user_email']]);

  //  $userData = select("users", ["*"], [], ["email" => $_SESSION['user_email']]);
    $currentCurrency = getCurrentCurrency();
    $baseCurrency = $config['payment_info']['default_currency'];

    $convertedBalance = convertAmount($userData["balance"], $baseCurrency, $currentCurrency);

    return [
      "currentCurrency" => $currentCurrency,
      "finalBalance" => $convertedBalance,
    ];
}

function convertAmount($amount, $baseCurrency, $currentCurrency)
{
    global $config;

    $currentRate = $config['payment_info']['currencies'][$currentCurrency];
    $baseRate = $config['payment_info']['currencies'][$baseCurrency];
    return convertPrice($amount, $baseCurrency, $currentCurrency, $baseRate, $currentRate);
}
