<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

function getCountData($counterId): array
{
    global $db_connect, $smarty, $lang, $config;

    $counterWidget = $db_connect->get("counters", "*", ["uniq_name" => $counterId]);

    $objectData = [
        "objectCount" => 0,
        "totalCount" => 0
    ];
    if (!empty($counterWidget) && $counterWidget["active"] === true || $counterWidget["active"] == 1) {
        $countObjectParentName = $counterWidget["name"];
        $fromCount = $counterWidget["from_count"];
        $toCount = $counterWidget["to_count"];
        $counterSubObjectType = $counterWidget["counter_sub_object"];

        $modules = [];
        foreach ($config['modules'] as $name => $mConfig) {
            if ($mConfig['used'] === true) {
                $modules[] = $name;
            }
        }

        if ($counterSubObjectType == "views") {
            try {
                if ($counterWidget["name"] == "all_modules") {
                    foreach ($modules as $module) {
                        $objectData["objectCount"] += $db_connect->sum($module, "views") ?? 0;
                    }
                } else {
                    $objectData["objectCount"] = $db_connect->sum($counterWidget["name"], "views");
                }
            } catch (Exception $e) {

            }
        } elseif ($counterSubObjectType == "comments") {
            if ($counterWidget["name"] == "all_modules") {
                foreach ($modules as $module) {
                    $objectData["objectCount"] += $db_connect->count("comments", ["entity_type" => $module, "status" => 1]);
                }
            } else {
                $objectData["objectCount"] = $db_connect->count("comments", ["entity_type" => $counterWidget["name"], "status" => 1]);
            }
        } elseif ($counterSubObjectType == "user_groups_count") {
            if ($counterWidget["name"] == "all_groups") {
                $objectData["objectCount"] = $db_connect->count("users");
            } else {
                $groupId = $db_connect->get("roles", "id", ["name" => $counterWidget["name"]]);
                $objectData["objectCount"] = $db_connect->count("users", ["group" => $groupId]);
            }

            if ($fromCount == 0 && !empty($toCount)) {
                $objectData["totalCount"] = (int)$toCount - (int)$objectData["objectCount"];
            }

        } elseif ($counterSubObjectType == "all_rows") {
            if ($counterWidget["name"] == "all_modules") {
                foreach ($modules as $module) {
                    $objectData["objectCount"] += $db_connect->count($module);
                }
            } else {
                $objectData["objectCount"] = $db_connect->count($counterWidget["name"]);
            }
        } elseif ($counterSubObjectType == "category_count") {
            if ($counterWidget["name"] == "all_modules") {
                foreach ($modules as $module) {
                    $objectData["objectCount"] += $db_connect->count($module."_categories");
                }
            } else {
                $objectData["objectCount"] = $db_connect->count($counterWidget["name"]."_categories");
            }
        }

    }
/*
    $text = ""; //;
    if ($counterWidget["object_type"] == "modules") {
        $moduleName = $lang['module_name'] ?? $lang['topmenu'];
        $text .= $lang['datatable'][$counterWidget["counter_sub_object"]]." ({$moduleName[$counterWidget["name"]]}): ". "<b>{$objectData["objectCount"]}</b>";
    }*/


    $smarty->assign("objectData", $objectData);
    $smarty->assign("counterWidget", $counterWidget);
  //  $smarty->assign("text", $text);

    return $objectData;
}

