<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    function changeCurrency($newCurrency, $config) {
        if (array_key_exists($newCurrency, $config['payment_info']['currencies'])) {
            $_SESSION['current_currency'] = $newCurrency;
        }
    }
    function getCurrentCurrency() {
        return isset($_SESSION['current_currency']) ? $_SESSION['current_currency'] : getDefaultCurrency();
    }
    function getDefaultCurrency() {
        global $config;
        return $config['payment_info']['default_currency'];
    }
    function convertPrice($price, $baseCurrency, $currentCurrency, $baseRate, $currentRate) {
        $price = floatval($price);
        $baseRate = floatval($baseRate);
        $currentRate = floatval($currentRate);
        return round($price * ($currentRate / $baseRate), 2);
    }
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'change_currency' && isset($_POST['currency'])) {
        $newCurrency = $_POST['currency'];
        changeCurrency($newCurrency, $config);
        header("Location: " . $_SERVER['REQUEST_URI']);
        exit();
    }

    // // Передача конфигурации в Smarty
    $smarty->assign('currencies', $config['payment_info']['currencies']);
    $smarty->assign('selectedCurrency', $_SESSION['selected_currency'] ?? null);