<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once(ENGINE_DIR."/mods/database_helper.php");

function insertDelivery($transactionId, $deliveryData)
{
    global $user_id, $db_connect;

    $status = "pending";

    $db_connect->insert("deliveries", [
        "user_id" => $user_id,
        "name" => $deliveryData["delivery_name"],
        "country" => $deliveryData["delivery_country"],
        "address" => $deliveryData["delivery_address"],
        "phone" => $deliveryData["delivery_phone"],
        "order_id" => $transactionId,
        "delivery_status" => $status,
    ]);


}

function getDeliveryByUserId()
{
    global  $user_id, $db_connect;

    return $db_connect->get("deliveries", "*", ["user_id" => $user_id]);
}
