<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    function getDirectorySize($dir) {
        if (!is_dir($dir)) {
            return false;
        }
        $size = 0;
        $items = array_diff(scandir($dir), ['.', '..']);
        foreach ($items as $item) {
            $path = $dir . DIRECTORY_SEPARATOR . $item;
            if (is_dir($path)) {
                $size += getDirectorySize($path); // Рекурсивно подсчитываем размер подпапок
            } else {
                $size += filesize($path); // Подсчитываем размер файла
            }
        }
        return $size; // Возвращаем общий размер папки в байтах
    }
    
    // Получаем размер папки
    $folderSize = getDirectorySize($calculation_folder);
    
    // Форматируем размер в MB
    $folderSizeMB = $folderSize / 1024 / 1024;
    
    // Приводим к нужному формату с двумя знаками после запятой
    $formattedSize = number_format($folderSizeMB, 2, '.', '');