<?php
    error_reporting(E_ALL & ~E_WARNING);

    ini_set('display_errors', 0);
    ini_set('log_errors', 1);

    set_error_handler(function($errno, $errstr, $errfile, $errline) {
        $errorMessage = sprintf(
            "[%s] PHP Error: [%d] %s in %s on line %d\n",
            date("Y-m-d H:i:s"),
            $errno, $errstr, $errfile, $errline
        );
        file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/engine/data/error_log.txt', $errorMessage, FILE_APPEND);

        return false;
    });

    set_exception_handler(function($e) {
        $errorMessage = sprintf(
            "[%s] Uncaught Exception: %s in %s on line %d\nStack trace:\n%s\n\n",
            date("Y-m-d H:i:s"),
            $e->getMessage(), $e->getFile(), $e->getLine(), $e->getTraceAsString()
        );
        file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/engine/data/error_log.txt', $errorMessage, FILE_APPEND);

        http_response_code(500);

        // Красиво показываем пользователю
        global $smarty, $config;
        if (isset($smarty)) {
            if ($config['dev_mode'] === true) {
                $smarty->assign("error_message", $errorMessage);
            } else {
                $smarty->assign("error_message", "Внутренняя ошибка сервера. Мы уже работаем над её исправлением.");
            }
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/blocks/error.tpl');
        } else {
            echo "Ошибка сервера. Попробуйте позже.";
        }
    });

    register_shutdown_function(function() {
        $error = error_get_last();
        if ($error && ($error["type"] === E_ERROR || $error["type"] === E_CORE_ERROR || $error["type"] === E_COMPILE_ERROR)) {
            $errorMessage = sprintf(
                "[%s] Fatal error: %s in %s on line %d\n\n",
                date("Y-m-d H:i:s"),
                $error["message"], $error["file"], $error["line"]
            );
            file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/engine/data/error_log.txt', $errorMessage, FILE_APPEND);

            http_response_code(500);
            echo "Внутренняя ошибка сервера. Мы уже работаем над её исправлением.";
        }
    });

    /*function displayError($e)
    {
        global $smarty, $config;

        $errorMessage = sprintf(
            "[%s] %s in %s on line %d\nStack trace:\n%s\n\n",
            date("Y-m-d H:i:s"),
            $e->getMessage(),
            $e->getFile(),
            $e->getLine(),
            $e->getTraceAsString()
        );

        file_put_contents(__DIR__ . '/var/logs/error_log.txt', $errorMessage, FILE_APPEND);

        error_log($errorMessage);

        if (isset($smarty)) {
            $smarty->assign("error_message", $errorMessage);
            $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/blocks/error.tpl');
        } else {
            echo "Ошибка сервера. Попробуйте позже.";
        }

    }*/