<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

function getDynamicFieldValues($database, $entity_id, $module_type) {
    global $lang;

    $fieldsTable = "{$module_type}_fields";
    $valuesTable = "{$module_type}_field_values";
    $entity_column = "{$module_type}_id";

    // Получение всех возможных полей
    $fields = $database->select($fieldsTable, ['id']);
    if (!$fields) {
        return [];
    }

    // Формируем массив всех полей с заглушками
    $fieldsArray = [];
    foreach ($fields as $field) {
        $fieldsArray[$field['id']] = [
            'x_value' => '' // Значение по умолчанию
        ];
    }

    // Получение значений полей для конкретной сущности
    $values = $database->select($valuesTable, ['field_id', 'x_value'], [
        $entity_column => $entity_id
    ]);

    // Обновляем значения для полей, если данные есть
    foreach ($values as $row) {
        if (isset($fieldsArray[$row['field_id']])) {
            $fieldsArray[$row['field_id']]['x_value'] = $row['x_value'];
        }
    }

    // Разбиваем данные на отдельные массивы, заменяя пустые строки на null
    $x_value = [];
    foreach ($fieldsArray as $field) {
        $x_value[] = $field['x_value'] !== '' ? $field['x_value'] : null;
    }

    return [
        'x_value' => $x_value
    ];
}