<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Определите путь к файлу
    $filePath = $moduletype['file_path'];

    // Проверяем, существует ли файл
    if (file_exists($filePath)) {
        // Получаем размер файла в байтах
        $fileSizeBytes = filesize($filePath);

        // Определяем единицы измерения
        if ($fileSizeBytes < 1024) {
            // Если размер файла меньше 1 КБ, оставляем в байтах
            $fileSizeFormatted = $fileSizeBytes . ' Б';
        } elseif ($fileSizeBytes < (1024 * 1024)) {
            // Если размер файла меньше 1 МБ, переводим в килобайты
            $fileSizeFormatted = round($fileSizeBytes / 1024, 2) . ' КБ';
        } elseif ($fileSizeBytes < (1024 * 1024 * 1000)) {
            // Если размер файла меньше 1 ГБ, переводим в мегабайты
            $fileSizeFormatted = round($fileSizeBytes / (1024 * 1024), 2) . ' МБ';
        } else {
            // Если размер файла больше 1 ГБ, переводим в гигабайты
            $fileSizeFormatted = round($fileSizeBytes / (1024 * 1024 * 1024), 2) . ' ГБ';
        }
        $fileExists = true;
    } else {
        // Если файл не существует
        $fileSizeFormatted = '0 Б';
        $fileExists = false;
    }

    // Устанавливаем массив переменных в Smarty
    $smarty->assign('fileSizeFormatted', $fileSizeFormatted);
    $smarty->assign('fileExists', $fileExists);