<?php

    //    /*
    //        *****************************************************************************
    //        * MEGA Digital Space - by MEGA Digital Studio                               *
    //        * ------------------------------------------------------------------------- *
    //        * CMS Website:  https://megadigital.space                                   *
    //        * License:  https://megadigital.space/license                               *
    //        * Owner:  Giorgi Basharuli                                                  *
    //        * Contact:  online@megadigital.studio                                       *
    //        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    //        * Website:  https://megadigital.studio                                      *
    //        * ------------------------------------------------------------------------- *
    //        * Description: This file is a part of the MEGA Digital Space CMS system.    *
    //        * Unauthorized distribution, modification, or commercial use is strictly -  *
    //        * prohibited without prior written permission.                              *
    //        * ------------------------------------------------------------------------- *
    //        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    //        * All rights reserved.                                                      *
    //        *****************************************************************************
    //    *

    function getCategoriesString($moduleId, $moduleName)
    {

        global $db_connect;

        $categoriesString = "";


        $newsCatRelations = $db_connect->select(
            $moduleName.'_cat_relations(ncr)',
            [
                '[>]'.$moduleName.'_categories(nc)' => ['ncr.category_id' => 'id']
            ],
            [
                'nc.name'
            ],
            [
                'ncr.'.$moduleName.'_id' => $moduleId
            ]
        );

        $categoriesList = [];
        if (!empty($newsCatRelations)) {
            foreach ($newsCatRelations as $newsCatRelation) {
                $categoriesList[] = $newsCatRelation["name"];
            }
        }


        return implode(', ', $categoriesList);
    }

    function getCategoriesList($moduleId, $moduleName, $subModuleName = null)
    {

        global $db_connect;

        $newsCatRelations = $db_connect->select(
            $moduleName.'_cat_relations(ncr)',
            [
                '[>]'.$moduleName.'_categories(nc)' => ['ncr.category_id' => 'id']
            ],
            [
                'nc.name'
            ],
            [
                'ncr.'.($subModuleName !== null?$subModuleName.'_id':$moduleName.'_id') => $moduleId
            ]
        );

        $categoriesList = [];
        if (!empty($newsCatRelations)) {
            foreach ($newsCatRelations as $newsCatRelation) {
                $categoriesList[] = $newsCatRelation["name"];
            }
        }


        return $categoriesList;
    }

    function getCategoriesIds($moduleId, $moduleName, $subModuleName = null)
    {

        global $db_connect;

        $newsCatRelations = $db_connect->select(
            $moduleName.'_cat_relations(ncr)',
            [
                '[>]'.$moduleName.'_categories(nc)' => ['ncr.category_id' => 'id']
            ],
            [
                'nc.id'
            ],
            [
                'ncr.'.($subModuleName !== null?$subModuleName.'_id':$moduleName.'_id') => $moduleId
            ]
        );

        $categoriesList = [];
        if (!empty($newsCatRelations)) {
            foreach ($newsCatRelations as $newsCatRelation) {
                $categoriesList[] = $newsCatRelation["id"];
            }
        }


        return $categoriesList;
    }

    function getCategoriesAltNames($moduleId, $moduleName, $subModuleName = null)
    {

        global $db_connect;

        $categories = getCategoriesList($moduleId, $moduleName, $subModuleName);

        $altNames = [];
        foreach ($categories as $category) {
            $category = trim($category);
            $altName = $db_connect->get($moduleName.'_categories', 'alt_name', [
                'name' => $category
            ]);
            $altNames[] = $altName ? $altName : '';
        }

        return implode(',', $altNames);

    }

    function getModuleCategoriesDataList($moduleName)
    {
        global $db_connect;

        return $db_connect->select($moduleName."_categories", "*") ?? [];

    }