<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */
    
    // Определяем ключ для языка в сессии в зависимости от $config['lang_union']
    $session_lang_key = $config['lang_union'] ? 'lang' : 'language';

    // Функция для загрузки языкового файла
    function load_language($lang_code) {
        // Путь к основному языковому файлу
        $lang_file = ENGINE_DIR . "/lang/{$lang_code}/website.lng"; // Путь к языковому файлу для админки
        $fields_file = ENGINE_DIR . "/lang/{$lang_code}/fields.lng"; // Путь к языковому файлу для полей
        $chat_file = ENGINE_DIR . "/lang/{$lang_code}/chat.lng"; // Путь к языковому файлу для чата


        // Загружаем основной языковой файл
        if (file_exists($lang_file)) {
            $lang = include $lang_file; // Возвращаем массив
        } else {
            // Если язык не найден, используем язык по умолчанию (например, русский)
            $lang = include ENGINE_DIR . "/lang/russian/website.lng"; // Путь к русскому файлу
        }
    
        // Загружаем файл для полей, если он существует
        if (file_exists($fields_file)) {
            $fields = include $fields_file; // Возвращаем массив полей
            // Объединяем массивы
            $lang = array_merge($lang, $fields);
        } else {
            // Если файл для полей не найден, используем данные по умолчанию
            $fields_default = include ENGINE_DIR . "/lang/russian/fields.lng";
            $lang = array_merge($lang, $fields_default);
        }



        if (file_exists($chat_file)) {
            $chat_lang = include $chat_file; // Возвращаем массив
            $lang = array_merge($lang, $chat_lang);

        } else {
            // Если язык не найден, используем язык по умолчанию (например, русский)
            $chat_lang = include ENGINE_DIR . "/lang/russian/chat.lng"; // Путь к русскому файлу
            $lang = array_merge($lang, $chat_lang);

        }

        return $lang;
    }

    // Функция для получения доступных языков
    function get_available_languages() {
        $lang_dir = ENGINE_DIR . '/lang';
        $languages = [];
        if (is_dir($lang_dir)) {
            $folders = scandir($lang_dir);
            foreach ($folders as $folder) {
                if ($folder !== '.' && $folder !== '..' && is_dir($lang_dir . '/' . $folder)) {
                    $languages[] = $folder;
                }
            }
        }
        return $languages;
    }

    // Сначала проверяем, был ли язык передан через URL
    if (isset($_GET['lang'])) {
        $lang = $_GET['lang'];

        if (empty($lang)) {
            $lang = $config['default_lang'];
        }

        // Проверяем, существует ли папка с языковым файлом
        if (is_dir(ENGINE_DIR . "/lang/{$lang}")) {
            $_SESSION[$session_lang_key] = $lang; // Сохраняем выбранный язык в сессии
        }
        // После установки языка через URL, перенаправляем на тот же URL без параметра lang
        $current_url = strtok($_SERVER['REQUEST_URI'], '?'); // Убираем параметры из URL
        header("Location: $current_url");
        exit;
    }

    // Обрабатываем смену языка через форму
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['unique_form_id']) && $_POST['unique_form_id'] === 'language_selection_form') {
            $lang = $_POST['lang'];
            // Проверяем, существует ли папка с языковым файлом
            if (is_dir(ENGINE_DIR . "/lang/{$lang}")) {
                $_SESSION[$session_lang_key] = $lang; // Сохраняем выбранный язык в с   ессии
            }
            // Получаем текущий URL из скрытого поля
            $current_url = $_POST['current_url'] ?? $_SERVER['PHP_SELF']; // Используем POST или PHP_SELF как fallback
            // Перенаправляем пользователя обратно на страницу
            header("Location: $current_url");
            exit;
        }
    }

    // Получаем и родителя, и его прямых детей
    $allLocations = $db_connect->select('locations', [
        '[>]location_translations' => ['id' => 'location_id']
    ], [
        'locations.id',
        'locations.parent_id',
        'locations.type',
        'locations.slug',
        'location_translations.name',
    ], [
        'location_translations.language_code' => $_SESSION['lang'] ?? $config['default_lang'],
    ]);

    if (empty($allLocations)) {
        $allLocations = $db_connect->select('locations', [
            '[>]location_translations' => ['id' => 'location_id']
        ], [
            'locations.id',
            'locations.parent_id',
            'locations.type',
            'locations.slug',
            'location_translations.name',
        ], [
            'location_translations.language_code' => "english",
        ]);
    }

    // Рекурсивная функция для фильтрации дерева
    function getTree($locations, $parentId) {
        $tree = [];

        // Найти родителя
        foreach ($locations as $loc) {
            if ($loc['id'] == $parentId) {
                $node = $loc;

                // Добавляем детей рекурсивно
                $children = [];
                foreach ($locations as $child) {
                    if ($child['parent_id'] == $loc['id']) {
                        $children[] = getTree($locations, $child['id'])[0]; // [0] т.к. getTree возвращает массив
                    }
                }

                if (!empty($children)) {
                    $node['children'] = $children;
                } else {
                    $node['children'] = [];
                }

                $tree[] = $node;
                break; // родитель найден, можно выйти
            }
        }

        return $tree;
    }


    //$parentId = 8; // Например США
    $parentId = $db_connect->get("locations", "id", ["slug" => $config["default_country_slug"], "parent_id" => null]);

    $locationsTree = getTree($allLocations, $parentId);

    function slugify($text) {
        $words = preg_split('/\s+/', trim($text));
        $slug = '';
        if (count($words) >= 2) {
            $slug = strtoupper(substr($words[0], 0, 1) . substr($words[1], 0, 1));
        } elseif (count($words) === 1 && strlen($words[0]) >= 2) {
            $slug = strtoupper(substr($words[0], 0, 2));
        } else {
            $slug = strtoupper(substr($text, 0, 2));
        }
        return $slug ?: uniqid('LC');
    }

    $locationName = '';
    $locationSlug = '';

    // Язык интерфейса
    $lang = "english";
    $userId = (int)($_SESSION['user_id'] ?? 0);

    // 1) Если у пользователя уже есть выбранная локация — берём её
    $selectedLocation = $db_connect->get("location_list", "*", [
        "user_id" => $userId,
    ]);

    if (!empty($selectedLocation)) {
        $locationId = (int)$selectedLocation['location_id'];

        $locationName = $db_connect->get("location_translations", "name", [
            "language_code" => $lang,
            "location_id"   => $locationId,
        ]);

        $locationSlug = $db_connect->get("locations", "slug", [
            "id" => $locationId,
        ]);

    } else {
        require_once(ENGINE_DIR . '/mods/locationV2.php');
        $requestFullInfo = getRequestUserFullInfo();

        if (empty($_SESSION["locationStr"])) {
            if (!empty($requestFullInfo) && isset($requestFullInfo['allGeoInfo'])) {
                $allGeoInfo = $requestFullInfo['allGeoInfo'];
                if (($allGeoInfo['status'] ?? null) === 'success') {
                    $country = trim((string)($allGeoInfo['country'] ?? ''));
                    if ($country === 'United States') {
                        $country = 'USA';
                    }

                    $stateName = trim((string)($allGeoInfo['regionName'] ?? ''));
                    $cityName  = trim((string)($allGeoInfo['city'] ?? ''));

                    // --- Страна
                    $countryId = (int)$db_connect->get('location_translations', 'location_id', [
                        'name'          => $country,
                        'language_code' => $lang,
                    ]);
                    if (!$countryId) {
                        $countryId = (int)$db_connect->get('location_translations', 'location_id', [
                            'name' => $country,
                        ]);
                    }
                    if (!$countryId && $country !== '') {
                        $db_connect->insert('locations', [
                            'parent_id' => null,
                            'name'     => '',
                            'type'     => 'country',
                            'slug'     => slugify($country),
                        ]);
                        $countryId = (int)$db_connect->id();

                        $db_connect->insert('location_translations', [
                            'language_code' => $lang,
                            'location_id'   => $countryId,
                            'name'          => $country,
                        ]);
                    }

                    // --- Штат
                    $stateId = 0;
                    $stateSlug = '';
                    if ($countryId && $stateName !== '') {
                        $detectedState = $db_connect->get('locations', [
                            '[>]location_translations' => ['id' => 'location_id'],
                        ], [
                            'locations.id',
                            'locations.slug',
                            'locations.type',
                            'location_translations.name',
                        ], [
                            'locations.parent_id'                 => $countryId,
                            'locations.type'                      => 'state',
                            'location_translations.language_code' => $lang,
                            'location_translations.name'          => $stateName,
                            'LIMIT'                                => 1,
                        ]);

                        if (!empty($detectedState)) {
                            $stateId = (int)$detectedState['id'];
                            $stateSlug = $detectedState['slug'];
                        } else {
                            $stateSlug = slugify($stateName);
                            $db_connect->insert('locations', [
                                'parent_id' => $countryId,
                                'name'     => '',
                                'type'     => 'state',
                                'slug'     => $stateSlug,
                            ]);
                            $stateId = (int)$db_connect->id();

                            $db_connect->insert('location_translations', [
                                'language_code' => $lang,
                                'location_id'   => $stateId,
                                'name'          => $stateName,
                            ]);
                        }
                    }

                    // --- Город
                    $cityId = 0;
                    if ($stateId && $cityName !== '') {
                        $detectedCity = $db_connect->get('locations', [
                            '[>]location_translations' => ['id' => 'location_id'],
                        ], [
                            'locations.id',
                            'locations.slug',
                            'locations.type',
                            'location_translations.name',
                        ], [
                            'locations.parent_id'                 => $stateId,
                            'locations.type'                      => 'city',
                            'location_translations.language_code' => $lang,
                            'location_translations.name'          => $cityName,
                            'LIMIT'                                => 1,
                        ]);

                        if (!empty($detectedCity)) {
                            $cityId = (int)$detectedCity['id'];
                        } else {
                            // создаём город, но slug такой же как у штата
                            $db_connect->insert('locations', [
                                'parent_id' => $stateId,
                                'name'     => '',
                                'type'     => 'city',
                                'slug'     => $stateSlug,
                            ]);
                            $cityId = (int)$db_connect->id();

                            $db_connect->insert('location_translations', [
                                'language_code' => $lang,
                                'location_id'   => $cityId,
                                'name'          => $cityName,
                            ]);
                        }
                    }

                    // --- Итог
                    $finalLocationId = $cityId ?: ($stateId ?: $countryId);

                    if ($finalLocationId) {
                        if ($userId > 0) {
                            $exists = $db_connect->has('location_list', ['user_id' => $userId]);
                            if ($exists) {
                                $db_connect->update('location_list', [
                                    'location_id' => $finalLocationId,
                                ], [
                                    'user_id' => $userId,
                                ]);
                            } else {
                                $db_connect->insert('location_list', [
                                    'user_id'     => $userId,
                                    'location_id' => $finalLocationId,
                                ]);
                            }
                        }

                        $locationName = (string)$db_connect->get('location_translations', 'name', [
                            'language_code' => $lang,
                            'location_id'   => $finalLocationId,
                        ]);

                        $locationSlug = (string)$db_connect->get('locations', 'slug', [
                            'id' => $finalLocationId,
                        ]);

                        // если пользователь гость — сохраняем во временной сессии
                        if ($userId === 0) {
                            $_SESSION['locationId'] = $finalLocationId;
                            $_SESSION['locationStr'] = !empty($locationSlug)
                                ? $locationSlug . ", " . $locationName
                                : $locationName;
                        } else {
                            $db_connect->update('users', [
                                "detected_location_id" => $finalLocationId
                            ], ["id" => $userId]);
                        }
                    }
                }
            }

        }

    }

    $langCodes = [
        'chinese' => "CHI",
        'english' => "ENG",
        'french' => "FRA",
        'german' => "GER",
        'hindi' => "IND",
        'portuguese' => "PRT",
        'russian' => "RUS",
        'spanish' => "SPA",
        'turkish' => "TUR",
        'ukrainian' => "UKR",

    ];

// Устанавливаем язык из сессии или используем язык по умолчанию
    $lang_code = isset($_SESSION[$session_lang_key]) ? $_SESSION[$session_lang_key] : $config['default_lang'];
    
    // Преобразуем язык в нижний регистр
    $lang_code = strtolower($lang_code);

    // Загружаем языковой файл
    $lang = load_language($lang_code);

    // Получаем доступные языки
    $available_languages = get_available_languages();
    $smarty->assign('locationsTree', $locationsTree);

    // Передаем данные в шаблон
    if (!empty($_SESSION["user_id"])) {
        $smarty->assign('locationName', $locationSlug === "" ? $_SESSION['locationStr'] ?? "" : $locationSlug);
    } else {
        $smarty->assign('locationName', $locationName === "" ? $_SESSION['locationStr'] ?? "" : $locationName);
    }
    $smarty->assign('locationSlug', $locationSlug === "" ? explode(', ', $_SESSION['locationStr'] ?? "")[0] ?? "" : $locationSlug);

    $selectedLang = isset($_SESSION['lang']) && isset($langCodes[$_SESSION['lang']])
        ? $langCodes[$_SESSION['lang']]
        : $langCodes[$config['default_lang']];

    $smarty->assign('selectedLang', $_SESSION["lang"] ?? $config['default_lang']);
    $smarty->assign('selectedCurrency', $_SESSION['current_currency'] ?? $config["payment_info"]["default_currency"]);
    $smarty->assign('lang', $lang);
  //  $smarty->assign('locations', $locations);
    $smarty->assign('available_languages', $available_languages);
    $smarty->assign('current_lang', $lang_code);

    // Получаем текущий URL
    $current_url = $_SERVER['REQUEST_URI'];
    $smarty->assign('current_url', $current_url);