<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Функция для получения внешнего IP-адреса пользователя
    function getUserIpAdd() {
        // Проверяем все возможные заголовки для IP
        $ip = '';
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            // В случае наличия нескольких IP в заголовке, берем первый (обычно это IPv4)
            $ip_list = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
            $ip = trim($ip_list[0]);
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }

        // Если адрес в формате IPv6, пытаемся конвертировать в IPv4
        if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) {
            // Если это IPv4-мэппинг на IPv6
            if (strpos($ip, '::ffff:') === 0) {
                $ip = substr($ip, 7); // Убираем префикс '::ffff:'
            } else {
                // Пробуем получить IPv4-адрес через DNS
                $dns_result = dns_get_record($ip, DNS_A);
                if (!empty($dns_result) && isset($dns_result[0]['ip'])) {
                    $ip = $dns_result[0]['ip'];
                }
            }
        }

        return $ip;
    }

    // Функция для проверки, является ли IP-адрес локальным
    function isLocalIp($ip) {
        if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) === false) {
            return true;
        }
        return false;
    }

    // Получите IP-адрес пользователя
    $userIp = getUserIpAdd();
    $smarty->assign('externalIp', $userIp);

    // Инициализация переменной для города
    $city = 'город не определен';

    // Проверьте, является ли IP-адрес локальным
    if (isLocalIp($userIp)) {
        $city = 'local server';
    } else {
        // Функция для получения данных о местоположении
        function getLocation($ip) {
            $url = "http://ip-api.com/json/{$ip}";
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $response = curl_exec($ch);
            curl_close($ch);
            
            return json_decode($response, true);
        }

        // Получите данные о местоположении пользователя
        $location = getLocation($userIp);

        // Проверьте, что данные о местоположении были получены корректно
        if (isset($location['city'])) {
            $city = $location['city'];
        }
    }

    // Передача города в шаблон Smarty
    $smarty->assign('city', $city);