<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once $_SERVER['DOCUMENT_ROOT'].'/vendor/autoload.php';

use DeviceDetector\DeviceDetector;

function getRequestUserFullInfo()
{
    $userAgent = $_SERVER['HTTP_USER_AGENT'];

    $dd = new DeviceDetector($userAgent);
    $dd->parse();

    if ($dd->isBot()) {
        $deviceInfo = 'Bot detected: ' . $dd->getBot()['name'];
    } else {
        $os = $dd->getOs();
        $client = $dd->getClient();

        $osSystem = "Operating System:". $os['name'] . ' ' . $os['version'];
        $browser = "Browser:". $client['name'] . ' ' . $client['version'];
        $deviceType = $dd->getDeviceName();

        $deviceInfo = $osSystem . ", " . $browser . ", " . $deviceType;
    }

    $geoInfo = [];
    $ipAddress = getUserIP();
    if ($ipAddress !== 'UNKNOWN' && $ipAddress !== '127.0.0.1') {
        $geoInfo = getGeoInfo($ipAddress);

        if ($geoInfo['status'] === 'success') {
            $location = $geoInfo['country'] .", ". $geoInfo["regionName"] .", ". $geoInfo["city"];
        } else {
            $location = "Error: " . $geoInfo['message'];
        }
    } else {
        $location = "Unable to determine IP address.";
    }

    return [
        "location" => $location,
        "deviceInfo" => $deviceInfo,
        "ipAddress" => $ipAddress,
        "country" => $geoInfo["country"] ?? "unknown",
        "allGeoInfo" => $geoInfo,
    ];
}

function getUserIP() {
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } elseif (!empty($_SERVER['REMOTE_ADDR'])) {
        $ip = $_SERVER['REMOTE_ADDR'];
    } else {
        $ip = 'UNKNOWN';
    }

    return explode(',', $ip)[0];
}

function getGeoInfo($ip) {
    $url = "http://ip-api.com/json/$ip?fields=status,message,country,regionName,city,lat,lon,query";
    $response = file_get_contents($url);
    return json_decode($response, true);
}
