<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Подключаем определитель локации
    require_once(ENGINE_DIR . '/mods/location.php');

    // Подключение к базе данных
    require_once(ENGINE_DIR . '/data/dbconfig.php');

    // Инициализация переменной для сообщений
    $message = '';

    if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit_lot_participants'])) {
        // Получаем данные из формы
        $lot_title = trim($_POST['lot_title']);
        $user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : null;
        $username = isset($_POST['username']) ? trim($_POST['username']) : null;
        $phone = trim($_POST['phone']);
        $social_url = trim($_POST['social_url']);
        $ip = $userIp; // Используем IP-адрес из location.php
        $registration_date = $config['date_format'];
        $status = 'pending';
        $notes = trim($_POST['notes']);
        $city = $smarty->getTemplateVars('city');
        $security_question_id = intval($_POST['security_question_id']);
        $user_answer = trim($_POST['security_answer']);
    
        // Проверка обязательных полей
        if ((empty($username) && !$user_id) || empty($phone) || empty($social_url) || empty($lot_title)) {
            $message = "Пожалуйста, заполните все обязательные поля.";
        } else {
            // Проверка ответа на вопрос безопасности
            $query = "SELECT answer FROM security_questions WHERE id = ?";
            $stmt = mysqli_prepare($db_connect, $query);
    
            if (!$stmt) {
                die('Ошибка подготовки запроса (security_question): ' . mysqli_error($db_connect));
            }
    
            mysqli_stmt_bind_param($stmt, "i", $security_question_id);
            mysqli_stmt_execute($stmt);
            $result = mysqli_stmt_get_result($stmt);
            $question = mysqli_fetch_assoc($result);
            
            // Проверка правильности ответа
            if ($question && $user_answer !== $question['answer']) {
                $message = "Неверный ответ на вопрос безопасности.";
            } else {
                // Сбрасываем счетчик автоинкремента после успешного добавления
                require_once(ENGINE_DIR . '/mods/autoincrement.php');
                resetAutoIncrement($db_connect, 'lot_participants');
    
                // Если пользователь не авторизован, используем имя из формы
                if (!$user_id) {
                    $user_id = 0; // Или другой ID для неавторизованных
                }
    
                // Запись данных в таблицу
                $insert_lot_participants = "INSERT INTO `lot_participants` (`lot_title`, `user_id`, `username`, `phone`, `social_url`, `ip`, `registration_date`, `status`, `notes`, `city`) VALUES (?, ?, ?, ?, ?, ?, NOW(), ?, ?, ?)";
                $stmt = mysqli_prepare($db_connect, $insert_lot_participants);
    
                if (!$stmt) {
                    die('Ошибка подготовки запроса (insert): ' . mysqli_error($db_connect));
                }
    
                mysqli_stmt_bind_param($stmt, "sisssssss", $lot_title, $user_id, $username, $phone, $social_url, $ip, $status, $notes, $city);
    
                if (mysqli_stmt_execute($stmt)) {
                    $message = "Ваша заявка на участие отправлена!";
                } else {
                    $message = "Ошибка при добавлении участника: " . mysqli_error($db_connect);
                }
            }
        }
    }
    
    // Передача сообщения в шаблон
    $smarty->assign('message', $message);    