<?php

    //    /*
    //        *****************************************************************************
    //        * MEGA Digital Space - by MEGA Digital Studio                               *
    //        * ------------------------------------------------------------------------- *
    //        * CMS Website:  https://megadigital.space                                   *
    //        * License:  https://megadigital.space/license                               *
    //        * Owner:  Giorgi Basharuli                                                  *
    //        * Contact:  online@megadigital.studio                                       *
    //        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    //        * Website:  https://megadigital.studio                                      *
    //        * ------------------------------------------------------------------------- *
    //        * Description: This file is a part of the MEGA Digital Space CMS system.    *
    //        * Unauthorized distribution, modification, or commercial use is strictly -  *
    //        * prohibited without prior written permission.                              *
    //        * ------------------------------------------------------------------------- *
    //        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    //        * All rights reserved.                                                      *
    //        *****************************************************************************
    //    *


    function getFilterDataList($moduleName, $lang_code, $start, $additionalColumns = [], $filterCategory = null, $subModule = null, $excludeColumns = [])
    {

        global $db_connect, $config, $smarty;

        $filterCategory = $_GET['category'] ?? $filterCategory;
        $filterSort = $_GET['sort'] ?? '';

        $smarty->assign('filterCategory', $filterCategory);
        $smarty->assign('filterSort', $filterSort);

        $conditions = [
            'n.language' => $lang_code,
            'GROUP' => 'n.id',
        ];

        if (!empty($start)) {
            $conditions["LIMIT"] = [$start, $config['modules'][$moduleName][$moduleName.'_per_page']];
        }

        if (!empty($filterCategory)) {
            $conditions['ncr.category_id'] = (int)$filterCategory;
        }

        if (!empty($filterSort)) {
            if ($moduleName == "news") {
                if ($filterSort == 'date') {
                    $conditions['ORDER'] = ['n.date' => 'DESC'];
                } else if ($filterSort == 'views') {
                    $conditions['ORDER'] = ['n.views' => 'DESC'];
                } else if ($filterSort == 'rating') {
                    $conditions['ORDER'] = ['n.rating' => 'DESC'];
                }
            }

        }

        $selectColumns = [
            'n.language',
            'n.title',
            'n.image',
            'n.short_desc',
            'n.full_desc',
            'n.alt_name',
            'n.views',
            'n.id',
        ];

        $selectColumns = array_merge($selectColumns, $additionalColumns);

        foreach ($selectColumns as $key => $column) {
            if (in_array($column, $excludeColumns)) {
                unset($selectColumns[$key]);
            }
        }

        return $db_connect->select(
            ($subModule === null?$moduleName:$subModule).'(n)',
            [
                '[>]'.$moduleName.'_cat_relations(ncr)' => ['id' => ($moduleName == "shop" ? "product" : $moduleName).'_id']
            ],
            $selectColumns,
            $conditions
        ) ?? [];

    }