<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    // Проверяем, объявлена ли переменная $controllerDir
    if (!isset($controllerDir)) {
        $controllerDir = ENGINE_DIR . '/controllers/modules/';
    }

    // Функция для проверки активности модуля
    function isModuleActive($module) {
        // Путь к директории контроллеров
        global $controllerDir, $config;
        // Проверяем, существует ли ключ модуля в конфиге
        if (!isset($config['modules'][$module]) || !$config['modules'][$module]) {
            return false; // Если ключа нет или он ложный, модуль не активен
        }
        // Формируем пути к файлам короткого и полного контроллера модуля
        $shortFile = $controllerDir . $module . '/short-' . $module . '.php';
        $fullFile = $controllerDir . $module . '/full-' . $module . '.php';
        // Если оба файла существуют, модуль активен
        return file_exists($shortFile) && file_exists($fullFile);
    }
    
    function isModuleUsed($module) {
        global $config;
        // Проверяем, существует ли модуль и используется ли он
        return isset($config['modules'][$module]['used']) && $config['modules'][$module]['used'];
    }

    // Проверяем доступность каждого модуля
    $lotsAvailable = isModuleActive('lots');
    $adsAvailable = isModuleActive('ads');
    $eventsAvailable = isModuleActive('events');
    $filesAvailable = isModuleActive('files');
    $moviesAvailable = isModuleActive('movies');
    $newsAvailable = isModuleActive('news');
    $productsAvailable = isModuleActive('products');
    $auctionsAvailable = isModuleActive('auctions');
    $couponsAvailable = isModuleActive('coupons');
    $shopAvailable = isModuleActive('shop');

    // Передаём данные в шаблон Smarty
    $smarty->assign('lotsAvailable', $lotsAvailable);
    $smarty->assign('adsAvailable', $adsAvailable);
    $smarty->assign('eventsAvailable', $eventsAvailable);
    $smarty->assign('filesAvailable', $filesAvailable);
    $smarty->assign('moviesAvailable', $moviesAvailable);
    $smarty->assign('newsAvailable', $newsAvailable);
    $smarty->assign('productsAvailable', $productsAvailable);
    $smarty->assign('auctionsAvailable', $auctionsAvailable);
    $smarty->assign('couponsAvailable', $couponsAvailable);
    $smarty->assign('shopAvailable', $shopAvailable);

    // Проверяем активность каждого модуля
    $lotsUsed = isModuleUsed('lots');
    $adsUsed = isModuleUsed('ads');
    $eventsUsed = isModuleUsed('events');
    $filesUsed = isModuleUsed('files');
    $moviesUsed = isModuleUsed('movies');
    $newsUsed = isModuleUsed('news');
    $productsUsed = isModuleUsed('products');
    $auctionsUsed = isModuleUsed('auctions');
    $couponsUsed = isModuleUsed('coupons');
    $shopUsed = isModuleUsed('shop');

    // Передаём данные в шаблон Smarty
    $smarty->assign('lotsUsed', $lotsUsed);
    $smarty->assign('adsUsed', $adsUsed);
    $smarty->assign('eventsUsed', $eventsUsed);
    $smarty->assign('filesUsed', $filesUsed);
    $smarty->assign('moviesUsed', $moviesUsed);
    $smarty->assign('newsUsed', $newsUsed);
    $smarty->assign('productsUsed', $productsUsed);
    $smarty->assign('auctionsUsed', $auctionsUsed);
    $smarty->assign('couponsUsed', $couponsUsed);
    $smarty->assign('shopUsed', $shopUsed);