<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    $roleName = null;

    if (!empty($_SESSION["user_email"])) {
        $user = $db_connect->get("users", "*", [
            "email" => $_SESSION["user_email"]
        ]);

        $role = $db_connect->get("roles", "name", [
            "id" => $user["role_id"] ?? 0
        ]);

        $roleName = $role ?? null;
    }

    // Закрытый сайт — пропускаем только Admin
    if ((empty($roleName) || $roleName !== "Admin") && $config['site_offline'] === true) {
        $smarty->display(TEMPLATES_DIR . '/' . $config['skin'] . '/offline.tpl');
        exit;
    } else {
        $tplFile = TEMPLATES_DIR . '/' . $config['skin'] . '/main.tpl';

        $original = file_get_contents($tplFile);

        $patched = renderTempTpl($smarty, $original, true);
        file_put_contents($tplFile, $patched);

        $html = $smarty->fetch($tplFile);
        file_put_contents($tplFile, $original);

        echo $html;

    }