<?php
    /*
        *****************************************************************************
        * MEGA Digital Space - by MEGA Digital Studio                               *
        * ------------------------------------------------------------------------- *
        * CMS Website:  https://megadigital.space                                   *
        * License:  https://megadigital.space/license                               *
        * Owner:  Giorgi Basharuli                                                  *
        * Contact:  online@megadigital.studio                                       *
        * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
        * Website:  https://megadigital.studio                                      *
        * ------------------------------------------------------------------------- *
        * Description: This file is a part of the MEGA Digital Space CMS system.    *
        * Unauthorized distribution, modification, or commercial use is strictly -  *
        * prohibited without prior written permission.                              *
        * ------------------------------------------------------------------------- *
        * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
        * All rights reserved.                                                      *
        *****************************************************************************
    */

    function hasPermission($userId, $permissionCode): bool
    {

        global $db_connect;

        return (bool)$db_connect->get("role_permissions", [
            "[>]permissions" => ["permission_id" => "id"],
            "[>]users_roles" => ["role_id" => "role_id"]
        ], "role_permissions.allow", [
            "users_roles.user_id" => $userId,
            "permissions.code" => $permissionCode,
            "role_permissions.allow" => 1
        ]);
    }


    function teacherCanGrade($teacherId, $studentId): bool
    {
        global $db_connect;

        return (bool)$db_connect->get("teacher_classes", [
            "[>]class_students" => ["class_id" => "class_id"]
        ], "teacher_classes.teacher_id", [
            "teacher_classes.teacher_id" => $teacherId,
            "class_students.student_id" => $studentId
        ]);
    }
