<?php
/*
    *****************************************************************************
    * MEGA Digital Space - by MEGA Digital Studio                               *
    * ------------------------------------------------------------------------- *
    * CMS Website:  https://megadigital.space                                   *
    * License:  https://megadigital.space/license                               *
    * Owner:  Giorgi Basharuli                                                  *
    * Contact:  online@megadigital.studio                                       *
    * MEGA Digital Studio – Official Development Studio for MEGA Digital Space  *
    * Website:  https://megadigital.studio                                      *
    * ------------------------------------------------------------------------- *
    * Description: This file is a part of the MEGA Digital Space CMS system.    *
    * Unauthorized distribution, modification, or commercial use is strictly -  *
    * prohibited without prior written permission.                              *
    * ------------------------------------------------------------------------- *
    * Copyright (c) 2023-2025 MEGA Digital Studio.                              *
    * All rights reserved.                                                      *
    *****************************************************************************
*/

require_once(ENGINE_DIR."/mods/database_helper.php");

function calculateDiscount($promoCode, $totalAmount, $db_connect) {

    $result = checkPromocode($promoCode, $db_connect);

    if (!empty($result)) {
        $promo = $result;

        $count = (int)$promo['count'];
        $usageLimit = (int)$promo['usage_limit'];

        if (isset($promo['usage_limit']) && $usageLimit <= $count) {
            return [
                'success' => false,
                'message' => 'Usage limit reached for this promo code.',
                'finalAmount' => $totalAmount
            ];
        }

        $discountValue = $promo['discount_percent'];
        $discountAmount = ($discountValue / 100) * $totalAmount;

        if ($discountAmount > $totalAmount) {
            $discountAmount = $totalAmount;
        }

        $finalAmount = $totalAmount - $discountAmount;

        $newCount = (string)($count + 1);

        $db_connect->update("promocodes", [
            'count' => $newCount,
        ], ["code" => $promoCode]);

        return [
            'success' => true,
            'discountAmount' => $discountAmount,
            'finalAmount' => $finalAmount,
            'discountPercent' => $promo['discount_percent']
        ];
    } else {
        return [
            'success' => false,
            'message' => 'Invalid or expired promo code.',
            'finalAmount' => $totalAmount
        ];
    }
}

function checkPromocode($promocode, $db_connect)
{
    global $db_connect;

    $result = $db_connect->get("promocodes", "*", [
        "code" => $promocode,
    ]);

    return $result;
}
